/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Triple;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.spec.QuerySegmentSpec;

public class DataSourceAnalysis {
    private final DataSource dataSource;
    private final DataSource baseDataSource;
    @Nullable
    private final Query<?> baseQuery;
    @Nullable
    private final DimFilter joinBaseTableFilter;
    private final List<PreJoinableClause> preJoinableClauses;

    private DataSourceAnalysis(DataSource dataSource, DataSource baseDataSource, @Nullable Query<?> baseQuery, @Nullable DimFilter joinBaseTableFilter, List<PreJoinableClause> preJoinableClauses) {
        if (baseDataSource instanceof JoinDataSource) {
            throw new IAE("Base dataSource cannot be a join! Original dataSource was: %s", new Object[]{dataSource});
        }
        this.dataSource = dataSource;
        this.baseDataSource = baseDataSource;
        this.baseQuery = baseQuery;
        this.joinBaseTableFilter = joinBaseTableFilter;
        this.preJoinableClauses = preJoinableClauses;
    }

    public static DataSourceAnalysis forDataSource(DataSource dataSource) {
        Query baseQuery = null;
        DataSource current = dataSource;
        while (current instanceof QueryDataSource) {
            Query subQuery = ((QueryDataSource)current).getQuery();
            if (!(subQuery instanceof BaseQuery)) {
                throw new IAE("Cannot analyze subquery of class[%s]", new Object[]{subQuery.getClass().getName()});
            }
            baseQuery = subQuery;
            current = subQuery.getDataSource();
        }
        if (current instanceof JoinDataSource) {
            Triple<DataSource, DimFilter, List<PreJoinableClause>> flattened = DataSourceAnalysis.flattenJoin((JoinDataSource)current);
            return new DataSourceAnalysis(dataSource, (DataSource)flattened.first, baseQuery, (DimFilter)flattened.second, (List)flattened.third);
        }
        return new DataSourceAnalysis(dataSource, current, baseQuery, null, Collections.emptyList());
    }

    private static Triple<DataSource, DimFilter, List<PreJoinableClause>> flattenJoin(JoinDataSource dataSource) {
        DataSource current = dataSource;
        DimFilter currentDimFilter = null;
        ArrayList<PreJoinableClause> preJoinableClauses = new ArrayList<PreJoinableClause>();
        while (current instanceof JoinDataSource) {
            JoinDataSource joinDataSource = current;
            current = joinDataSource.getLeft();
            if (currentDimFilter != null) {
                throw new IAE("Left filters are only allowed when left child is direct table access", new Object[0]);
            }
            currentDimFilter = joinDataSource.getLeftFilter();
            preJoinableClauses.add(new PreJoinableClause(joinDataSource.getRightPrefix(), joinDataSource.getRight(), joinDataSource.getJoinType(), joinDataSource.getConditionAnalysis()));
        }
        Collections.reverse(preJoinableClauses);
        return Triple.of((Object)current, currentDimFilter, preJoinableClauses);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataSource getBaseDataSource() {
        return this.baseDataSource;
    }

    public Optional<TableDataSource> getBaseTableDataSource() {
        if (this.baseDataSource instanceof TableDataSource) {
            return Optional.of((TableDataSource)this.baseDataSource);
        }
        return Optional.empty();
    }

    public Optional<UnionDataSource> getBaseUnionDataSource() {
        if (this.baseDataSource instanceof UnionDataSource) {
            return Optional.of((UnionDataSource)this.baseDataSource);
        }
        return Optional.empty();
    }

    public Optional<Query<?>> getBaseQuery() {
        return Optional.ofNullable(this.baseQuery);
    }

    public Optional<DimFilter> getJoinBaseTableFilter() {
        return Optional.ofNullable(this.joinBaseTableFilter);
    }

    public Optional<QuerySegmentSpec> getBaseQuerySegmentSpec() {
        return this.getBaseQuery().map(query -> ((BaseQuery)query).getQuerySegmentSpec());
    }

    public List<PreJoinableClause> getPreJoinableClauses() {
        return this.preJoinableClauses;
    }

    public boolean isGlobal() {
        return this.dataSource.isGlobal();
    }

    public boolean isConcreteBased() {
        return this.baseDataSource.isConcrete() && this.preJoinableClauses.stream().allMatch(clause -> clause.getDataSource().isGlobal());
    }

    public boolean isConcreteTableBased() {
        return this.isConcreteBased() && (this.baseDataSource instanceof TableDataSource || this.baseDataSource instanceof UnionDataSource && this.baseDataSource.getChildren().stream().allMatch(ds -> ds instanceof TableDataSource));
    }

    public boolean isQuery() {
        return this.dataSource instanceof QueryDataSource;
    }

    public boolean isJoin() {
        return !this.preJoinableClauses.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceAnalysis that = (DataSourceAnalysis)o;
        return Objects.equals(this.dataSource, that.dataSource);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource);
    }

    public String toString() {
        return "DataSourceAnalysis{dataSource=" + this.dataSource + ", baseDataSource=" + this.baseDataSource + ", baseQuery=" + this.baseQuery + ", preJoinableClauses=" + this.preJoinableClauses + '}';
    }
}

