/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.metadata.AllColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.joda.time.Interval;

public class SegmentMetadataQuery
extends BaseQuery<SegmentAnalysis> {
    private static final QuerySegmentSpec DEFAULT_SEGMENT_SPEC = new MultipleIntervalSegmentSpec((List<Interval>)Intervals.ONLY_ETERNITY);
    private final ColumnIncluderator toInclude;
    private final boolean merge;
    private final boolean usingDefaultInterval;
    private final EnumSet<AnalysisType> analysisTypes;
    private final boolean lenientAggregatorMerge;

    @JsonCreator
    public SegmentMetadataQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="toInclude") ColumnIncluderator toInclude, @JsonProperty(value="merge") Boolean merge, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="analysisTypes") EnumSet<AnalysisType> analysisTypes, @JsonProperty(value="usingDefaultInterval") Boolean useDefaultInterval, @JsonProperty(value="lenientAggregatorMerge") Boolean lenientAggregatorMerge) {
        super(dataSource, querySegmentSpec == null ? DEFAULT_SEGMENT_SPEC : querySegmentSpec, false, context);
        this.usingDefaultInterval = querySegmentSpec == null ? true : (useDefaultInterval == null ? false : useDefaultInterval);
        this.toInclude = toInclude == null ? new AllColumnIncluderator() : toInclude;
        this.merge = merge == null ? false : merge;
        this.analysisTypes = analysisTypes;
        Preconditions.checkArgument((dataSource instanceof TableDataSource || dataSource instanceof UnionDataSource ? 1 : 0) != 0, (Object)"SegmentMetadataQuery only supports table or union datasource");
        this.lenientAggregatorMerge = lenientAggregatorMerge == null ? false : lenientAggregatorMerge;
    }

    @JsonProperty
    public ColumnIncluderator getToInclude() {
        return this.toInclude;
    }

    @JsonProperty
    public boolean isMerge() {
        return this.merge;
    }

    @JsonProperty
    public boolean isUsingDefaultInterval() {
        return this.usingDefaultInterval;
    }

    @Override
    public boolean hasFilters() {
        return false;
    }

    @Override
    public DimFilter getFilter() {
        return null;
    }

    @Override
    public String getType() {
        return "segmentMetadata";
    }

    @JsonProperty
    public EnumSet<AnalysisType> getAnalysisTypes() {
        return this.analysisTypes;
    }

    @JsonProperty
    public boolean isLenientAggregatorMerge() {
        return this.lenientAggregatorMerge;
    }

    public boolean analyzingInterval() {
        return this.analysisTypes.contains((Object)AnalysisType.INTERVAL);
    }

    public boolean hasAggregators() {
        return this.analysisTypes.contains((Object)AnalysisType.AGGREGATORS);
    }

    public boolean hasTimestampSpec() {
        return this.analysisTypes.contains((Object)AnalysisType.TIMESTAMPSPEC);
    }

    public boolean hasQueryGranularity() {
        return this.analysisTypes.contains((Object)AnalysisType.QUERYGRANULARITY);
    }

    public boolean hasRollup() {
        return this.analysisTypes.contains((Object)AnalysisType.ROLLUP);
    }

    @Override
    public Query<SegmentAnalysis> withOverriddenContext(Map<String, Object> contextOverride) {
        Map<String, Object> newContext = SegmentMetadataQuery.computeOverriddenContext(this.getContext(), contextOverride);
        return Druids.SegmentMetadataQueryBuilder.copy(this).context(newContext).build();
    }

    @Override
    public Query<SegmentAnalysis> withQuerySegmentSpec(QuerySegmentSpec spec) {
        return Druids.SegmentMetadataQueryBuilder.copy(this).intervals(spec).build();
    }

    @Override
    public Query<SegmentAnalysis> withDataSource(DataSource dataSource) {
        return Druids.SegmentMetadataQueryBuilder.copy(this).dataSource(dataSource).build();
    }

    public Query<SegmentAnalysis> withColumns(ColumnIncluderator includerator) {
        return Druids.SegmentMetadataQueryBuilder.copy(this).toInclude(includerator).build();
    }

    public SegmentMetadataQuery withFinalizedAnalysisTypes(SegmentMetadataQueryConfig config) {
        if (this.analysisTypes != null) {
            return this;
        }
        return Druids.SegmentMetadataQueryBuilder.copy(this).analysisTypes(config.getDefaultAnalysisTypes()).build();
    }

    @Override
    public List<Interval> getIntervals() {
        return this.getQuerySegmentSpec().getIntervals();
    }

    public String toString() {
        return "SegmentMetadataQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", toInclude=" + this.toInclude + ", merge=" + this.merge + ", usingDefaultInterval=" + this.usingDefaultInterval + ", analysisTypes=" + this.analysisTypes + ", lenientAggregatorMerge=" + this.lenientAggregatorMerge + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SegmentMetadataQuery that = (SegmentMetadataQuery)o;
        return this.merge == that.merge && this.usingDefaultInterval == that.usingDefaultInterval && this.lenientAggregatorMerge == that.lenientAggregatorMerge && Objects.equals(this.toInclude, that.toInclude) && Objects.equals(this.analysisTypes, that.analysisTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.toInclude, this.merge, this.usingDefaultInterval, this.analysisTypes, this.lenientAggregatorMerge);
    }

    public static enum AnalysisType implements Cacheable
    {
        CARDINALITY,
        SIZE,
        INTERVAL,
        AGGREGATORS,
        MINMAX,
        TIMESTAMPSPEC,
        QUERYGRANULARITY,
        ROLLUP;


        @JsonValue
        public String toString() {
            return StringUtils.toLowerCase((String)this.name());
        }

        @JsonCreator
        public static AnalysisType fromString(String name) {
            return AnalysisType.valueOf(StringUtils.toUpperCase((String)name));
        }

        public byte[] getCacheKey() {
            return new byte[]{(byte)this.ordinal()};
        }
    }
}

