/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;

public class ListColumnIncluderator
implements ColumnIncluderator {
    private static final byte[] LIST_CACHE_PREFIX = new byte[]{2};
    private final Set<String> columns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    @JsonCreator
    public ListColumnIncluderator(@JsonProperty(value="columns") List<String> columns) {
        this.columns.addAll(columns);
    }

    @JsonProperty
    public Set<String> getColumns() {
        return Collections.unmodifiableSet(this.columns);
    }

    @Override
    public boolean include(String columnName) {
        return this.columns.contains(columnName);
    }

    public byte[] getCacheKey() {
        int size = 1;
        ArrayList columns = Lists.newArrayListWithExpectedSize((int)this.columns.size());
        for (String column : this.columns) {
            byte[] bytes = StringUtils.toUtf8((String)column);
            columns.add(bytes);
            size += bytes.length + 1;
        }
        ByteBuffer bytes = ByteBuffer.allocate(size).put(LIST_CACHE_PREFIX);
        for (byte[] column : columns) {
            bytes.put(column);
            bytes.put((byte)-1);
        }
        return bytes.array();
    }
}

