/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.orderby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.Rows;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.TopNSequence;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ComparableList;
import org.apache.druid.segment.data.ComparableStringArray;

public class DefaultLimitSpec
implements LimitSpec {
    private static final byte CACHE_KEY = 1;
    private final List<OrderByColumnSpec> columns;
    private final int offset;
    private final int limit;

    public static Builder builder() {
        return new Builder();
    }

    public static boolean sortingOrderHasNonGroupingFields(DefaultLimitSpec limitSpec, List<DimensionSpec> dimensions) {
        for (OrderByColumnSpec orderSpec : limitSpec.getColumns()) {
            int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, dimensions);
            if (dimIndex >= 0) continue;
            return true;
        }
        return false;
    }

    public static StringComparator getComparatorForDimName(DefaultLimitSpec limitSpec, String dimName) {
        OrderByColumnSpec orderBy = OrderByColumnSpec.getOrderByForDimName(limitSpec.getColumns(), dimName);
        if (orderBy == null) {
            return null;
        }
        return orderBy.getDimensionComparator();
    }

    @JsonCreator
    public DefaultLimitSpec(@JsonProperty(value="columns") List<OrderByColumnSpec> columns, @JsonProperty(value="offset") Integer offset, @JsonProperty(value="limit") Integer limit) {
        this.columns = columns == null ? ImmutableList.of() : columns;
        this.offset = offset == null ? 0 : offset;
        this.limit = limit == null ? Integer.MAX_VALUE : limit;
        Preconditions.checkArgument((this.offset >= 0 ? 1 : 0) != 0, (String)"offset[%s] must be >= 0", (Object[])new Object[]{this.offset});
        Preconditions.checkArgument((this.limit > 0 ? 1 : 0) != 0, (String)"limit[%s] must be > 0", (Object[])new Object[]{this.limit});
    }

    @VisibleForTesting
    public DefaultLimitSpec(List<OrderByColumnSpec> columns, Integer limit) {
        this(columns, 0, limit);
    }

    @JsonProperty
    public List<OrderByColumnSpec> getColumns() {
        return this.columns;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getOffset() {
        return this.offset;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=LimitJsonIncludeFilter.class)
    public int getLimit() {
        return this.limit;
    }

    public boolean isOffset() {
        return this.offset > 0;
    }

    public boolean isLimited() {
        return this.limit < Integer.MAX_VALUE;
    }

    @Override
    public Function<Sequence<ResultRow>, Sequence<ResultRow>> build(GroupByQuery query) {
        Function sortAndLimitFn;
        QueryContext queryContext;
        String timestampField;
        List<DimensionSpec> dimensions = query.getDimensions();
        boolean sortingNeeded = dimensions.size() < this.columns.size();
        HashSet<String> aggAndPostAggNames = new HashSet<String>();
        for (AggregatorFactory agg : query.getAggregatorSpecs()) {
            aggAndPostAggNames.add(agg.getName());
        }
        for (PostAggregator postAgg : query.getPostAggregatorSpecs()) {
            aggAndPostAggNames.add(postAgg.getName());
        }
        if (!sortingNeeded) {
            for (int i = 0; i < this.columns.size(); ++i) {
                StringComparator naturalComparator;
                OrderByColumnSpec columnSpec = this.columns.get(i);
                if (aggAndPostAggNames.contains(columnSpec.getDimension())) {
                    sortingNeeded = true;
                    break;
                }
                ColumnType columnType = this.getOrderByType(columnSpec, dimensions);
                if (columnType.is((TypeDescriptor)ValueType.STRING)) {
                    naturalComparator = StringComparators.LEXICOGRAPHIC;
                } else if (columnType.isNumeric()) {
                    naturalComparator = StringComparators.NUMERIC;
                } else if (columnType.isArray()) {
                    naturalComparator = columnType.getElementType().isNumeric() ? StringComparators.NUMERIC : StringComparators.LEXICOGRAPHIC;
                } else {
                    sortingNeeded = true;
                    break;
                }
                if (columnSpec.getDirection() == OrderByColumnSpec.Direction.ASCENDING && columnSpec.getDimensionComparator().equals(naturalComparator) && columnSpec.getDimension().equals(dimensions.get(i).getOutputName())) continue;
                sortingNeeded = true;
                break;
            }
        }
        if (!sortingNeeded) {
            boolean bl = sortingNeeded = !query.getGranularity().equals(Granularities.ALL) && query.getContextSortByDimsFirst();
        }
        if (!sortingNeeded && (timestampField = (queryContext = query.context()).getString("timestampResultField")) != null && !timestampField.isEmpty()) {
            int timestampResultFieldIndex = queryContext.getInt("timestampResultFieldInOriginalDimensions");
            boolean bl = query.getContextSortByDimsFirst() ? timestampResultFieldIndex != query.getDimensions().size() - 1 : (sortingNeeded = timestampResultFieldIndex != 0);
        }
        if (sortingNeeded) {
            Ordering<ResultRow> ordering = this.makeComparator(query.getResultRowSignature(), query.getResultRowHasTimestamp(), query.getDimensions(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs(), query.getContextSortByDimsFirst());
            sortAndLimitFn = this.isLimited() ? results -> new TopNSequence(results, (Comparator)ordering, this.limit + this.offset) : results -> Sequences.sort((Sequence)results, (Comparator)ordering).limit((long)(this.limit + this.offset));
        } else {
            sortAndLimitFn = this.isLimited() ? results -> results.limit((long)(this.limit + this.offset)) : Functions.identity();
        }
        if (this.isOffset()) {
            return results -> ((Sequence)sortAndLimitFn.apply(results)).skip((long)this.offset);
        }
        return sortAndLimitFn;
    }

    @Override
    public LimitSpec merge(LimitSpec other) {
        return this;
    }

    private ColumnType getOrderByType(OrderByColumnSpec columnSpec, List<DimensionSpec> dimensions) {
        for (DimensionSpec dimSpec : dimensions) {
            if (!columnSpec.getDimension().equals(dimSpec.getOutputName())) continue;
            return dimSpec.getOutputType();
        }
        throw new ISE("Unknown column in order clause[%s]", new Object[]{columnSpec});
    }

    @Override
    public LimitSpec filterColumns(Set<String> names) {
        return new DefaultLimitSpec(this.columns.stream().filter(c -> names.contains(c.getDimension())).collect(Collectors.toList()), this.offset, this.limit);
    }

    public DefaultLimitSpec withOffsetToLimit() {
        if (this.isOffset()) {
            int newLimit;
            if (this.limit == Integer.MAX_VALUE) {
                newLimit = Integer.MAX_VALUE;
            } else {
                if (this.limit > Integer.MAX_VALUE - this.offset) {
                    throw new ISE("Cannot apply limit[%d] with offset[%d] due to overflow", new Object[]{this.limit, this.offset});
                }
                newLimit = this.limit + this.offset;
            }
            return new DefaultLimitSpec(this.columns, 0, newLimit);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private Ordering<ResultRow> makeComparator(RowSignature rowSignature, boolean hasTimestamp, List<DimensionSpec> dimensions, List<AggregatorFactory> aggs, List<PostAggregator> postAggs, boolean sortByDimsFirst) {
        void var11_20;
        void var11_16;
        Ordering<ResultRow> timeOrdering = hasTimestamp ? new Ordering<ResultRow>(){

            public int compare(ResultRow left, ResultRow right) {
                return Longs.compare((long)left.getLong(0), (long)right.getLong(0));
            }
        } : null;
        HashMap<String, DimensionSpec> dimensionsMap = new HashMap<String, DimensionSpec>();
        for (DimensionSpec dimensionSpec : dimensions) {
            dimensionsMap.put(dimensionSpec.getOutputName(), dimensionSpec);
        }
        HashMap<String, AggregatorFactory> aggregatorsMap = new HashMap<String, AggregatorFactory>();
        for (AggregatorFactory aggregatorFactory : aggs) {
            aggregatorsMap.put(aggregatorFactory.getName(), aggregatorFactory);
        }
        HashMap<String, PostAggregator> hashMap = new HashMap<String, PostAggregator>();
        for (PostAggregator postAgg : postAggs) {
            hashMap.put(postAgg.getName(), postAgg);
        }
        Object var11_15 = null;
        for (OrderByColumnSpec columnSpec : this.columns) {
            String columnName = columnSpec.getDimension();
            Ordering<ResultRow> nextOrdering = null;
            int columnIndex = rowSignature.indexOf(columnName);
            if (columnIndex >= 0) {
                if (hashMap.containsKey(columnName)) {
                    nextOrdering = this.metricOrdering(columnIndex, ((PostAggregator)hashMap.get(columnName)).getComparator());
                } else if (aggregatorsMap.containsKey(columnName)) {
                    nextOrdering = this.metricOrdering(columnIndex, ((AggregatorFactory)aggregatorsMap.get(columnName)).getComparator());
                } else if (dimensionsMap.containsKey(columnName)) {
                    Optional<DimensionSpec> dimensionSpec = dimensions.stream().filter(ds -> ds.getOutputName().equals(columnName)).findFirst();
                    if (!dimensionSpec.isPresent()) {
                        throw new ISE("Could not find the dimension spec for ordering column %s", new Object[]{columnName});
                    }
                    nextOrdering = this.dimensionOrdering(columnIndex, dimensionSpec.get().getOutputType(), columnSpec.getDimensionComparator());
                }
            }
            if (nextOrdering == null) {
                throw new ISE("Unknown column in order clause[%s]", new Object[]{columnSpec});
            }
            if (columnSpec.getDirection() == OrderByColumnSpec.Direction.DESCENDING) {
                nextOrdering = nextOrdering.reverse();
            }
            Ordering<ResultRow> ordering = var11_16 == null ? nextOrdering : var11_16.compound((Comparator)nextOrdering);
        }
        if (var11_16 == null) {
            Ordering<ResultRow> ordering = timeOrdering;
        } else if (timeOrdering != null) {
            Ordering ordering = sortByDimsFirst ? var11_16.compound((Comparator)timeOrdering) : timeOrdering.compound((Comparator)var11_16);
        }
        return var11_20 != null ? var11_20 : Ordering.allEqual();
    }

    private <T> Ordering<ResultRow> metricOrdering(int column, Comparator<T> comparator) {
        Comparator<T> nullFriendlyComparator = NullHandling.sqlCompatible() ? Comparator.nullsFirst(comparator) : Comparator.nullsLast(comparator);
        return Ordering.from(Comparator.comparing(row -> row.get(column), nullFriendlyComparator));
    }

    private Ordering<ResultRow> dimensionOrdering(int column, ColumnType columnType, StringComparator comparator) {
        Comparator arrayComparator = null;
        if (columnType.isArray()) {
            ValueType elementType = (ValueType)columnType.getElementType().getType();
            if (columnType.getElementType().isNumeric()) {
                arrayComparator = (o1, o2) -> ComparableList.compareWithComparator(comparator, DimensionHandlerUtils.convertToList(o1, elementType), DimensionHandlerUtils.convertToList(o2, elementType));
            } else if (columnType.getElementType().equals(ColumnType.STRING)) {
                arrayComparator = (o1, o2) -> ComparableStringArray.compareWithComparator(comparator, DimensionHandlerUtils.convertToComparableStringArray(o1), DimensionHandlerUtils.convertToComparableStringArray(o2));
            } else {
                throw new ISE("Cannot create comparator for array type %s.", new Object[]{columnType.toString()});
            }
        }
        return Ordering.from(Comparator.comparing(row -> {
            if (columnType.isArray()) {
                return row.get(column);
            }
            return DefaultLimitSpec.getDimensionValue(row, column);
        }, Comparator.nullsFirst(arrayComparator == null ? comparator : arrayComparator)));
    }

    @Nullable
    private static String getDimensionValue(ResultRow row, int column) {
        List values = Rows.objectToStrings((Object)row.get(column));
        return values.isEmpty() ? null : (String)Iterables.getOnlyElement((Iterable)values);
    }

    public String toString() {
        return "DefaultLimitSpec{columns='" + this.columns + '\'' + ", offset=" + this.offset + ", limit=" + this.limit + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLimitSpec that = (DefaultLimitSpec)o;
        return this.offset == that.offset && this.limit == that.limit && Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.offset, this.limit);
    }

    public byte[] getCacheKey() {
        byte[][] columnBytes = new byte[this.columns.size()][];
        int columnsBytesSize = 0;
        int index = 0;
        for (OrderByColumnSpec column : this.columns) {
            columnBytes[index] = column.getCacheKey();
            columnsBytesSize += columnBytes[index].length;
            ++index;
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + columnsBytesSize + 8).put((byte)1);
        for (byte[] columnByte : columnBytes) {
            buffer.put(columnByte);
        }
        buffer.putInt(this.limit);
        buffer.putInt(this.offset);
        return buffer.array();
    }

    public static class LimitJsonIncludeFilter {
        public boolean equals(Object obj) {
            return obj instanceof Integer && (Integer)obj == Integer.MAX_VALUE;
        }
    }

    public static class Builder {
        private List<OrderByColumnSpec> columns = Collections.emptyList();
        private Integer offset = null;
        private Integer limit = null;

        private Builder() {
        }

        public Builder orderBy(String ... columns) {
            return this.orderBy((OrderByColumnSpec[])Arrays.stream(columns).map(s -> new OrderByColumnSpec((String)s, OrderByColumnSpec.Direction.ASCENDING)).toArray(OrderByColumnSpec[]::new));
        }

        public Builder orderBy(OrderByColumnSpec ... columns) {
            this.columns = ImmutableList.copyOf(Arrays.asList(columns));
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public DefaultLimitSpec build() {
            return new DefaultLimitSpec(this.columns, this.offset, this.limit);
        }
    }
}

