/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryMetrics;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.BufferArrayGrouper;
import org.apache.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.druid.query.groupby.epinephelinae.GroupByQueryEngineV2;
import org.apache.druid.query.groupby.epinephelinae.HashVectorGrouper;
import org.apache.druid.query.groupby.epinephelinae.VectorGrouper;
import org.apache.druid.query.groupby.epinephelinae.collection.MemoryPointer;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnProcessorFactory;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.query.vector.VectorCursorGranularizer;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class VectorGroupByEngine {
    private VectorGroupByEngine() {
    }

    public static boolean canVectorize(GroupByQuery query, StorageAdapter adapter, @Nullable Filter filter) {
        ColumnInspector inspector = query.getVirtualColumns().wrapInspector(adapter);
        return adapter.canVectorize(filter, query.getVirtualColumns(), false) && VectorGroupByEngine.canVectorizeDimensions(inspector, query.getDimensions()) && VirtualColumns.shouldVectorize(query, query.getVirtualColumns(), adapter) && query.getAggregatorSpecs().stream().allMatch(aggregatorFactory -> aggregatorFactory.canVectorize(inspector));
    }

    public static boolean canVectorizeDimensions(ColumnInspector inspector, List<DimensionSpec> dimensions) {
        return dimensions.stream().allMatch(dimension -> {
            if (!dimension.canVectorize()) {
                return false;
            }
            if (dimension.mustDecorate()) {
                return false;
            }
            if (dimension.getOutputType().isArray()) {
                return false;
            }
            ColumnCapabilities columnCapabilities = inspector.getColumnCapabilities(dimension.getDimension());
            if (columnCapabilities == null) {
                return true;
            }
            return columnCapabilities.hasMultipleValues().isFalse();
        });
    }

    public static Sequence<ResultRow> process(final GroupByQuery query, final StorageAdapter storageAdapter, final ByteBuffer processingBuffer, final @Nullable DateTime fudgeTimestamp, @Nullable Filter filter, final Interval interval, final GroupByQueryConfig config, final DruidProcessingConfig processingConfig, final @Nullable GroupByQueryMetrics groupByQueryMetrics) {
        if (!VectorGroupByEngine.canVectorize(query, storageAdapter, filter)) {
            throw new ISE("Cannot vectorize", new Object[0]);
        }
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<ResultRow, CloseableIterator<ResultRow>>(){

            public CloseableIterator<ResultRow> make() {
                VectorCursor cursor = storageAdapter.makeVectorCursor(Filters.toFilter(query.getDimFilter()), interval, query.getVirtualColumns(), false, query.context().getVectorSize(), groupByQueryMetrics);
                if (cursor == null) {
                    return new CloseableIterator<ResultRow>(){

                        public boolean hasNext() {
                            return false;
                        }

                        public ResultRow next() {
                            throw new NoSuchElementException();
                        }

                        public void close() {
                        }
                    };
                }
                try {
                    VectorColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
                    List<GroupByVectorColumnSelector> dimensions = query.getDimensions().stream().map(dimensionSpec -> ColumnProcessors.makeVectorProcessor(dimensionSpec, GroupByVectorColumnProcessorFactory.instance(), columnSelectorFactory)).collect(Collectors.toList());
                    return new VectorGroupByEngineIterator(query, config, processingConfig, storageAdapter, cursor, interval, dimensions, processingBuffer, fudgeTimestamp);
                }
                catch (Throwable e) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable e2) {
                        e.addSuppressed(e2);
                    }
                    throw e;
                }
            }

            public void cleanup(CloseableIterator<ResultRow> iterFromMake) {
                try {
                    iterFromMake.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @VisibleForTesting
    static class VectorGroupByEngineIterator
    implements CloseableIterator<ResultRow> {
        private final GroupByQuery query;
        private final GroupByQueryConfig querySpecificConfig;
        private final DruidProcessingConfig processingConfig;
        private final StorageAdapter storageAdapter;
        private final VectorCursor cursor;
        private final List<GroupByVectorColumnSelector> selectors;
        private final ByteBuffer processingBuffer;
        private final DateTime fudgeTimestamp;
        private final int keySize;
        private final WritableMemory keySpace;
        private final VectorGrouper vectorGrouper;
        @Nullable
        private final VectorCursorGranularizer granulizer;
        private final Iterator<Interval> bucketIterator;
        @Nullable
        private Interval bucketInterval;
        private int partiallyAggregatedRows = -1;
        private long selectorInternalFootprint = 0L;
        @Nullable
        private CloseableGrouperIterator<MemoryPointer, ResultRow> delegate = null;

        VectorGroupByEngineIterator(GroupByQuery query, GroupByQueryConfig querySpecificConfig, DruidProcessingConfig processingConfig, StorageAdapter storageAdapter, VectorCursor cursor, Interval queryInterval, List<GroupByVectorColumnSelector> selectors, ByteBuffer processingBuffer, @Nullable DateTime fudgeTimestamp) {
            this.query = query;
            this.querySpecificConfig = querySpecificConfig;
            this.processingConfig = processingConfig;
            this.storageAdapter = storageAdapter;
            this.cursor = cursor;
            this.selectors = selectors;
            this.processingBuffer = processingBuffer;
            this.fudgeTimestamp = fudgeTimestamp;
            this.keySize = selectors.stream().mapToInt(GroupByVectorColumnSelector::getGroupingKeySize).sum();
            this.keySpace = WritableMemory.allocate((int)(this.keySize * cursor.getMaxVectorSize()));
            this.vectorGrouper = this.makeGrouper();
            this.granulizer = VectorCursorGranularizer.create(storageAdapter, cursor, query.getGranularity(), queryInterval);
            this.bucketIterator = this.granulizer != null ? this.granulizer.getBucketIterable().iterator() : Collections.emptyIterator();
            this.bucketInterval = this.bucketIterator.hasNext() ? this.bucketIterator.next() : null;
        }

        public ResultRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.delegate.next();
        }

        public boolean hasNext() {
            boolean moreToRead;
            if (this.delegate != null && this.delegate.hasNext()) {
                return true;
            }
            boolean bl = moreToRead = !this.cursor.isDone() || this.partiallyAggregatedRows >= 0;
            if (this.bucketInterval != null && moreToRead) {
                while (this.delegate == null || !this.delegate.hasNext()) {
                    if (this.delegate != null) {
                        this.delegate.close();
                        this.vectorGrouper.reset();
                        this.selectors.forEach(GroupByVectorColumnSelector::reset);
                        this.selectorInternalFootprint = 0L;
                    }
                    this.delegate = this.initNewDelegate();
                }
                return true;
            }
            return false;
        }

        public void close() throws IOException {
            Closer closer = Closer.create();
            closer.register((Closeable)this.vectorGrouper);
            if (this.delegate != null) {
                closer.register(this.delegate);
            }
            closer.register((Closeable)this.cursor);
            closer.close();
        }

        @VisibleForTesting
        VectorGrouper makeGrouper() {
            int cardinalityForArrayAggregation = GroupByQueryEngineV2.getCardinalityForArrayAggregation(this.querySpecificConfig, this.query, this.storageAdapter, this.processingBuffer);
            VectorGrouper grouper = cardinalityForArrayAggregation >= 0 ? new BufferArrayGrouper((Supplier<ByteBuffer>)Suppliers.ofInstance((Object)this.processingBuffer), AggregatorAdapters.factorizeVector(this.cursor.getColumnSelectorFactory(), this.query.getAggregatorSpecs()), cardinalityForArrayAggregation) : new HashVectorGrouper((Supplier<ByteBuffer>)Suppliers.ofInstance((Object)this.processingBuffer), this.keySize, AggregatorAdapters.factorizeVector(this.cursor.getColumnSelectorFactory(), this.query.getAggregatorSpecs()), this.querySpecificConfig.getBufferGrouperMaxSize(), this.querySpecificConfig.getBufferGrouperMaxLoadFactor(), this.querySpecificConfig.getBufferGrouperInitialBuckets());
            grouper.initVectorized(this.cursor.getMaxVectorSize());
            return grouper;
        }

        private CloseableGrouperIterator<MemoryPointer, ResultRow> initNewDelegate() {
            DateTime timestamp;
            assert (this.bucketInterval != null);
            DateTime dateTime = timestamp = this.fudgeTimestamp != null ? this.fudgeTimestamp : this.query.getGranularity().toDateTime(this.bucketInterval.getStartMillis());
            while (!this.cursor.isDone()) {
                int startOffset;
                if (this.partiallyAggregatedRows < 0) {
                    this.granulizer.setCurrentOffsets(this.bucketInterval);
                    startOffset = this.granulizer.getStartOffset();
                } else {
                    startOffset = this.granulizer.getStartOffset() + this.partiallyAggregatedRows;
                }
                if (this.granulizer.getEndOffset() > startOffset) {
                    int keyOffset = 0;
                    for (GroupByVectorColumnSelector selector : this.selectors) {
                        this.selectorInternalFootprint += (long)selector.writeKeys(this.keySpace, this.keySize, keyOffset, startOffset, this.granulizer.getEndOffset());
                        keyOffset += selector.getGroupingKeySize();
                    }
                    AggregateResult result = this.vectorGrouper.aggregateVector((Memory)this.keySpace, startOffset, this.granulizer.getEndOffset());
                    this.partiallyAggregatedRows = result.isOk() ? -1 : (this.partiallyAggregatedRows < 0 ? result.getCount() : (this.partiallyAggregatedRows += result.getCount()));
                } else {
                    this.partiallyAggregatedRows = -1;
                }
                if (this.partiallyAggregatedRows >= 0) break;
                if (!this.granulizer.advanceCursorWithinBucket()) {
                    this.bucketInterval = this.bucketIterator.hasNext() ? this.bucketIterator.next() : null;
                    break;
                }
                if (this.selectorInternalFootprint <= this.querySpecificConfig.getActualMaxSelectorDictionarySize(this.processingConfig)) continue;
                break;
            }
            boolean resultRowHasTimestamp = this.query.getResultRowHasTimestamp();
            int resultRowDimensionStart = this.query.getResultRowDimensionStart();
            int resultRowAggregatorStart = this.query.getResultRowAggregatorStart();
            return new CloseableGrouperIterator<MemoryPointer, ResultRow>(this.vectorGrouper.iterator(), entry -> {
                int i;
                ResultRow resultRow = ResultRow.create(this.query.getResultRowSizeWithoutPostAggregators());
                if (resultRowHasTimestamp) {
                    resultRow.set(0, timestamp.getMillis());
                }
                int keyOffset = 0;
                for (i = 0; i < this.selectors.size(); ++i) {
                    GroupByVectorColumnSelector selector = this.selectors.get(i);
                    selector.writeKeyToResultRow((MemoryPointer)entry.getKey(), keyOffset, resultRow, resultRowDimensionStart + i);
                    keyOffset += selector.getGroupingKeySize();
                }
                GroupByQueryEngineV2.convertRowTypesToOutputTypes(this.query.getDimensions(), resultRow, resultRowDimensionStart);
                for (i = 0; i < entry.getValues().length; ++i) {
                    resultRow.set(resultRowAggregatorStart + i, entry.getValues()[i]);
                }
                return resultRow;
            }, () -> {});
        }
    }
}

