/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.collection;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.groupby.epinephelinae.Groupers;
import org.apache.druid.query.groupby.epinephelinae.collection.HashTableUtils;

public class MemoryOpenHashTable {
    private static final byte USED_BYTE = 1;
    private static final int USED_BYTE_SIZE = 1;
    private final WritableMemory tableMemory;
    private final int keySize;
    private final int valueSize;
    private final int bucketSize;
    private final int maxSize;
    private final int numBuckets;
    private final int bucketMask;
    private int size;

    public MemoryOpenHashTable(WritableMemory tableMemory, int numBuckets, int maxSize, int keySize, int valueSize) {
        this.tableMemory = tableMemory;
        this.numBuckets = numBuckets;
        this.bucketMask = numBuckets - 1;
        this.maxSize = maxSize;
        this.keySize = keySize;
        this.valueSize = valueSize;
        this.bucketSize = MemoryOpenHashTable.bucketSize(keySize, valueSize);
        MemoryOpenHashTable.verifyMemoryIsByteBuffer((Memory)tableMemory);
        if (!tableMemory.getTypeByteOrder().equals(ByteOrder.nativeOrder())) {
            throw new ISE("tableMemory must be native byte order", new Object[0]);
        }
        if (tableMemory.getCapacity() != (long)MemoryOpenHashTable.memoryNeeded(numBuckets, this.bucketSize)) {
            throw new ISE("tableMemory must be size[%,d] but was[%,d]", new Object[]{MemoryOpenHashTable.memoryNeeded(numBuckets, this.bucketSize), tableMemory.getCapacity()});
        }
        if (maxSize >= numBuckets) {
            throw new ISE("maxSize must be less than numBuckets", new Object[0]);
        }
        if (Integer.bitCount(numBuckets) != 1) {
            throw new ISE("numBuckets must be a power of two but was[%,d]", new Object[]{numBuckets});
        }
        this.clear();
    }

    public static int memoryNeeded(int numBuckets, int bucketSize) {
        return numBuckets * bucketSize;
    }

    public static int bucketSize(int keySize, int valueSize) {
        return 1 + keySize + valueSize;
    }

    public void clear() {
        this.size = 0;
        for (int bucket = 0; bucket < this.numBuckets; ++bucket) {
            this.tableMemory.putByte((long)bucket * (long)this.bucketSize, (byte)0);
        }
    }

    public void copyTo(MemoryOpenHashTable other, @Nullable BucketCopyHandler copyHandler) {
        if (other.size() > 0) {
            other.clear();
        }
        for (int bucket = 0; bucket < this.numBuckets; ++bucket) {
            int bucketOffset = bucket * this.bucketSize;
            if (!this.isOffsetUsed(bucketOffset)) continue;
            int keyPosition = bucketOffset + 1;
            int keyHash = Groupers.smear(HashTableUtils.hashMemory((Memory)this.tableMemory, keyPosition, this.keySize));
            int newBucket = other.findBucket(keyHash, (Memory)this.tableMemory, keyPosition);
            if (newBucket >= 0) {
                throw new ISE("Found already-used bucket while copying", new Object[0]);
            }
            if (!other.canInsertNewBucket()) {
                throw new ISE("Unable to copy bucket to new table, size[%,d]", new Object[]{other.size()});
            }
            int newBucketOffset = -(newBucket + 1) * this.bucketSize;
            assert (!other.isOffsetUsed(newBucketOffset));
            this.tableMemory.copyTo((long)bucketOffset, other.tableMemory, (long)newBucketOffset, (long)this.bucketSize);
            ++other.size;
            if (copyHandler == null) continue;
            copyHandler.bucketCopied(bucket, -(newBucket + 1), this, other);
        }
        if (other.size() != this.size) {
            throw new ISE("New table size[%,d] != old table size[%,d] after copying", new Object[]{other.size(), this.size});
        }
    }

    public int findBucket(int keyHash, Memory keySpace, int keySpacePosition) {
        int bucket = keyHash & this.bucketMask;
        int bucketOffset;
        while (this.tableMemory.getByte((long)(bucketOffset = bucket * this.bucketSize)) != 0) {
            boolean keyFound = HashTableUtils.memoryEquals((Memory)this.tableMemory, bucketOffset + 1, keySpace, keySpacePosition, this.keySize);
            if (keyFound) {
                return bucket;
            }
            bucket = bucket + 1 & this.bucketMask;
        }
        return -bucket - 1;
    }

    public boolean canInsertNewBucket() {
        return this.size < this.maxSize;
    }

    public void initBucket(int bucket, Memory keySpace, int keySpacePosition) {
        int bucketOffset = bucket * this.bucketSize;
        assert (this.canInsertNewBucket() && !this.isOffsetUsed(bucketOffset));
        this.tableMemory.putByte((long)bucketOffset, (byte)1);
        keySpace.copyTo((long)keySpacePosition, this.tableMemory, (long)(bucketOffset + 1), (long)this.keySize);
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public int numBuckets() {
        return this.numBuckets;
    }

    public int keySize() {
        return this.keySize;
    }

    public int valueSize() {
        return this.valueSize;
    }

    public int bucketKeyOffset() {
        return 1;
    }

    public int bucketValueOffset() {
        return 1 + this.keySize;
    }

    public int bucketSize() {
        return this.bucketSize;
    }

    public int bucketMemoryPosition(int bucket) {
        return bucket * this.bucketSize;
    }

    public WritableMemory memory() {
        return this.tableMemory;
    }

    public IntIterator bucketIterator() {
        return new IntIterator(){
            private int curr = 0;
            private int currBucket = -1;

            public boolean hasNext() {
                return this.curr < MemoryOpenHashTable.this.size;
            }

            public int nextInt() {
                if (this.curr >= MemoryOpenHashTable.this.size) {
                    throw new NoSuchElementException();
                }
                ++this.currBucket;
                while (!MemoryOpenHashTable.this.isOffsetUsed(this.currBucket * MemoryOpenHashTable.this.bucketSize)) {
                    ++this.currBucket;
                }
                ++this.curr;
                return this.currBucket;
            }
        };
    }

    private boolean isOffsetUsed(int bucketOffset) {
        return this.tableMemory.getByte((long)bucketOffset) == 1;
    }

    private static void verifyMemoryIsByteBuffer(Memory memory) {
        ByteBuffer buffer = memory.getByteBuffer();
        if (buffer == null) {
            throw new ISE("tableMemory must be ByteBuffer-backed", new Object[0]);
        }
        if (!buffer.order().equals(ByteOrder.BIG_ENDIAN)) {
            throw new ISE("tableMemory's ByteBuffer must be in big-endian order", new Object[0]);
        }
        if ((long)buffer.capacity() != memory.getCapacity() || buffer.remaining() != buffer.capacity()) {
            throw new ISE("tableMemory's ByteBuffer must be coterminous", new Object[0]);
        }
    }

    public static interface BucketCopyHandler {
        public void bucketCopied(int var1, int var2, MemoryOpenHashTable var3, MemoryOpenHashTable var4);
    }
}

