/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.FunctionalIterator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryMetrics;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class GroupByQueryEngine {
    private static final int MISSING_VALUE = -1;
    private final Supplier<GroupByQueryConfig> config;
    private final NonBlockingPool<ByteBuffer> intermediateResultsBufferPool;

    @Inject
    public GroupByQueryEngine(Supplier<GroupByQueryConfig> config, @Global NonBlockingPool<ByteBuffer> intermediateResultsBufferPool) {
        this.config = config;
        this.intermediateResultsBufferPool = intermediateResultsBufferPool;
    }

    public Sequence<Row> process(final GroupByQuery query, StorageAdapter storageAdapter, @Nullable GroupByQueryMetrics groupByQueryMetrics) {
        if (storageAdapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        if (!query.context().getBoolean("groupByEnableMultiValueUnnesting", true)) {
            throw new UOE("GroupBy v1 does not support %s as false. Set %s to true or use groupBy v2", new Object[]{"groupByEnableMultiValueUnnesting", "groupByEnableMultiValueUnnesting"});
        }
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        if (intervals.size() != 1) {
            throw new IAE("Should only have one interval, got[%s]", new Object[]{intervals});
        }
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimFilter()));
        Sequence<Cursor> cursors = storageAdapter.makeCursors(filter, intervals.get(0), query.getVirtualColumns(), query.getGranularity(), false, groupByQueryMetrics);
        final ResourceHolder bufferHolder = this.intermediateResultsBufferPool.take();
        return Sequences.concat((Sequence)Sequences.withBaggage((Sequence)Sequences.map(cursors, (Function)new Function<Cursor, Sequence<Row>>(){

            public Sequence<Row> apply(final Cursor cursor) {
                return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Row, RowIterator>(){

                    public RowIterator make() {
                        return new RowIterator(query, cursor, (ByteBuffer)bufferHolder.get(), (GroupByQueryConfig)GroupByQueryEngine.this.config.get());
                    }

                    public void cleanup(RowIterator iterFromMake) {
                        CloseableUtils.closeAndWrapExceptions((Closeable)((Object)iterFromMake));
                    }
                });
            }
        }), (Closeable)bufferHolder));
    }

    private static class RowIterator
    implements CloseableIterator<Row> {
        private final GroupByQuery query;
        private final Cursor cursor;
        private final ByteBuffer metricsBuffer;
        private final int maxIntermediateRows;
        private final List<DimensionSelector> dimensions;
        private final ArrayList<String> dimNames;
        private final BufferAggregator[] aggregators;
        private final String[] metricNames;
        private final int[] sizesRequired;
        @Nullable
        private List<ByteBuffer> unprocessedKeys;
        private Iterator<Row> delegate;

        public RowIterator(GroupByQuery query, Cursor cursor, ByteBuffer metricsBuffer, GroupByQueryConfig config) {
            GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
            this.query = query;
            this.cursor = cursor;
            this.metricsBuffer = metricsBuffer;
            this.maxIntermediateRows = querySpecificConfig.getMaxIntermediateRows();
            this.unprocessedKeys = null;
            this.delegate = Collections.emptyIterator();
            List<DimensionSpec> dimensionSpecs = query.getDimensions();
            this.dimensions = Lists.newArrayListWithExpectedSize((int)dimensionSpecs.size());
            this.dimNames = Lists.newArrayListWithExpectedSize((int)dimensionSpecs.size());
            for (DimensionSpec dimSpec : dimensionSpecs) {
                if (!dimSpec.getOutputType().is((TypeDescriptor)ValueType.STRING)) {
                    throw new UnsupportedOperationException("GroupBy v1 only supports dimensions with an outputType of STRING.");
                }
                DimensionSelector selector = cursor.getColumnSelectorFactory().makeDimensionSelector(dimSpec);
                if (selector.getValueCardinality() == -1) {
                    throw new UnsupportedOperationException("GroupBy v1 does not support dimension selectors with unknown cardinality.");
                }
                this.dimensions.add(selector);
                this.dimNames.add(dimSpec.getOutputName());
            }
            List<AggregatorFactory> aggregatorSpecs = query.getAggregatorSpecs();
            this.aggregators = new BufferAggregator[aggregatorSpecs.size()];
            this.metricNames = new String[aggregatorSpecs.size()];
            this.sizesRequired = new int[aggregatorSpecs.size()];
            for (int i = 0; i < aggregatorSpecs.size(); ++i) {
                AggregatorFactory aggregatorSpec = aggregatorSpecs.get(i);
                this.aggregators[i] = aggregatorSpec.factorizeBuffered(cursor.getColumnSelectorFactory());
                this.metricNames[i] = aggregatorSpec.getName();
                this.sizesRequired[i] = aggregatorSpec.getMaxIntermediateSizeWithNulls();
            }
        }

        public boolean hasNext() {
            return this.delegate.hasNext() || !this.cursor.isDone();
        }

        public Row next() {
            if (this.delegate.hasNext()) {
                return this.delegate.next();
            }
            if (this.unprocessedKeys == null && this.cursor.isDone()) {
                throw new NoSuchElementException();
            }
            final PositionMaintainer positionMaintainer = new PositionMaintainer(0, this.sizesRequired, this.metricsBuffer.remaining());
            RowUpdater rowUpdater = new RowUpdater(this.metricsBuffer, this.aggregators, positionMaintainer);
            if (this.unprocessedKeys != null) {
                for (ByteBuffer key : this.unprocessedKeys) {
                    List unprocUnproc = rowUpdater.updateValues(key, (List)ImmutableList.of());
                    if (unprocUnproc == null) continue;
                    throw new ISE("Not enough memory to process the request.", new Object[0]);
                }
                this.cursor.advance();
            }
            while (!this.cursor.isDone() && rowUpdater.getNumRows() < this.maxIntermediateRows) {
                ByteBuffer key = ByteBuffer.allocate(this.dimensions.size() * 4);
                this.unprocessedKeys = rowUpdater.updateValues(key, this.dimensions);
                if (this.unprocessedKeys != null) break;
                this.cursor.advance();
            }
            if (rowUpdater.getPositions().isEmpty() && this.unprocessedKeys != null) {
                throw new ISE("Not enough memory to process even a single item.  Required [%,d] memory, but only have[%,d]", new Object[]{positionMaintainer.getIncrement(), this.metricsBuffer.remaining()});
            }
            this.delegate = FunctionalIterator.create(rowUpdater.getPositions().entrySet().iterator()).transform((Function)new Function<Map.Entry<ByteBuffer, Integer>, Row>(){
                private final DateTime timestamp;
                private final int[] increments;
                {
                    this.timestamp = cursor.getTime();
                    this.increments = positionMaintainer.getIncrements();
                }

                public Row apply(@Nullable Map.Entry<ByteBuffer, Integer> input) {
                    LinkedHashMap theEvent = Maps.newLinkedHashMap();
                    ByteBuffer keyBuffer = input.getKey().duplicate();
                    for (int i = 0; i < dimensions.size(); ++i) {
                        DimensionSelector dimSelector = (DimensionSelector)dimensions.get(i);
                        int dimVal = keyBuffer.getInt();
                        if (-1 == dimVal) continue;
                        theEvent.put(dimNames.get(i), dimSelector.lookupName(dimVal));
                    }
                    int position = input.getValue();
                    for (int i = 0; i < aggregators.length; ++i) {
                        theEvent.put(metricNames[i], aggregators[i].get(metricsBuffer, position));
                        position += this.increments[i];
                    }
                    for (PostAggregator postAggregator : query.getPostAggregatorSpecs()) {
                        theEvent.put(postAggregator.getName(), postAggregator.compute(theEvent));
                    }
                    return new MapBasedRow(this.timestamp, (Map)theEvent);
                }
            });
            return this.delegate.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            for (BufferAggregator agg : this.aggregators) {
                agg.close();
            }
        }
    }

    private static class PositionMaintainer {
        private final int[] increments;
        private final int increment;
        private final int max;
        private long nextVal;

        public PositionMaintainer(int start, int[] increments, int max) {
            this.nextVal = start;
            this.increments = increments;
            int theIncrement = 0;
            for (int inc : increments) {
                theIncrement += inc;
            }
            this.increment = theIncrement;
            this.max = max - this.increment;
        }

        @Nullable
        public Integer getNext() {
            if (this.nextVal > (long)this.max) {
                return null;
            }
            int retVal = (int)this.nextVal;
            this.nextVal += (long)this.increment;
            return retVal;
        }

        public int getIncrement() {
            return this.increment;
        }

        public int[] getIncrements() {
            return this.increments;
        }
    }

    private static class RowUpdater {
        private final ByteBuffer metricValues;
        private final BufferAggregator[] aggregators;
        private final PositionMaintainer positionMaintainer;
        private final Map<ByteBuffer, Integer> positions = new TreeMap<ByteBuffer, Integer>();
        private final Map<ByteBuffer, Integer> positionsHash = new HashMap<ByteBuffer, Integer>();

        public RowUpdater(ByteBuffer metricValues, BufferAggregator[] aggregators, PositionMaintainer positionMaintainer) {
            this.metricValues = metricValues;
            this.aggregators = aggregators;
            this.positionMaintainer = positionMaintainer;
        }

        public int getNumRows() {
            return this.positions.size();
        }

        public Map<ByteBuffer, Integer> getPositions() {
            return this.positions;
        }

        @Nullable
        private List<ByteBuffer> updateValues(ByteBuffer key, List<DimensionSelector> dims) {
            int thePosition;
            if (dims.size() > 0) {
                DimensionSelector dimSelector = dims.get(0);
                IndexedInts row = dimSelector.getRow();
                int rowSize = row.size();
                if (rowSize == 0) {
                    ByteBuffer newKey = key.duplicate();
                    newKey.putInt(-1);
                    return this.updateValues(newKey, dims.subList(1, dims.size()));
                }
                ArrayList<ByteBuffer> retVal = null;
                for (int i = 0; i < rowSize; ++i) {
                    ByteBuffer newKey = key.duplicate();
                    int dimValue = row.get(i);
                    newKey.putInt(dimValue);
                    List<ByteBuffer> unaggregatedBuffers = this.updateValues(newKey, dims.subList(1, dims.size()));
                    if (unaggregatedBuffers == null) continue;
                    if (retVal == null) {
                        retVal = new ArrayList<ByteBuffer>();
                    }
                    retVal.addAll(unaggregatedBuffers);
                }
                return retVal;
            }
            key.clear();
            Integer position = this.positionsHash.get(key);
            int[] increments = this.positionMaintainer.getIncrements();
            if (position == null) {
                ByteBuffer keyCopy = ByteBuffer.allocate(key.limit());
                keyCopy.put(key.asReadOnlyBuffer());
                keyCopy.clear();
                position = this.positionMaintainer.getNext();
                if (position == null) {
                    return Collections.singletonList(keyCopy);
                }
                this.positions.put(keyCopy, position);
                this.positionsHash.put(keyCopy, position);
                thePosition = position;
                for (int i = 0; i < this.aggregators.length; ++i) {
                    this.aggregators[i].init(this.metricValues, thePosition);
                    thePosition += increments[i];
                }
            }
            thePosition = position;
            for (int i = 0; i < this.aggregators.length; ++i) {
                this.aggregators[i].aggregate(this.metricValues, thePosition);
                thePosition += increments[i];
            }
            return null;
        }
    }
}

