/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.utils.JvmUtils;

public class GroupByQueryConfig {
    private static final Logger logger = new Logger(GroupByQueryConfig.class);
    public static final long AUTOMATIC = 0L;
    public static final String CTX_KEY_STRATEGY = "groupByStrategy";
    public static final String CTX_KEY_FORCE_LIMIT_PUSH_DOWN = "forceLimitPushDown";
    public static final String CTX_KEY_APPLY_LIMIT_PUSH_DOWN = "applyLimitPushDown";
    public static final String CTX_KEY_APPLY_LIMIT_PUSH_DOWN_TO_SEGMENT = "applyLimitPushDownToSegment";
    public static final String CTX_KEY_FORCE_PUSH_DOWN_NESTED_QUERY = "forcePushDownNestedQuery";
    public static final String CTX_KEY_EXECUTING_NESTED_QUERY = "executingNestedQuery";
    public static final String CTX_KEY_ARRAY_RESULT_ROWS = "resultAsArray";
    public static final String CTX_KEY_ENABLE_MULTI_VALUE_UNNESTING = "groupByEnableMultiValueUnnesting";
    public static final String CTX_KEY_BUFFER_GROUPER_MAX_SIZE = "bufferGrouperMaxSize";
    private static final String CTX_KEY_IS_SINGLE_THREADED = "groupByIsSingleThreaded";
    private static final String CTX_KEY_MAX_INTERMEDIATE_ROWS = "maxIntermediateRows";
    private static final String CTX_KEY_MAX_RESULTS = "maxResults";
    private static final String CTX_KEY_BUFFER_GROUPER_INITIAL_BUCKETS = "bufferGrouperInitialBuckets";
    private static final String CTX_KEY_BUFFER_GROUPER_MAX_LOAD_FACTOR = "bufferGrouperMaxLoadFactor";
    private static final String CTX_KEY_MAX_ON_DISK_STORAGE = "maxOnDiskStorage";
    private static final String CTX_KEY_FORCE_HASH_AGGREGATION = "forceHashAggregation";
    private static final String CTX_KEY_INTERMEDIATE_COMBINE_DEGREE = "intermediateCombineDegree";
    private static final String CTX_KEY_NUM_PARALLEL_COMBINE_THREADS = "numParallelCombineThreads";
    private static final String CTX_KEY_MERGE_THREAD_LOCAL = "mergeThreadLocal";
    private static final double MERGING_DICTIONARY_HEAP_FRACTION = 0.3;
    private static final double SELECTOR_DICTIONARY_HEAP_FRACTION = 0.1;
    private static final long MIN_AUTOMATIC_DICTIONARY_SIZE = 1L;
    private static final long MAX_AUTOMATIC_DICTIONARY_SIZE = 1000000000L;
    @JsonProperty
    private String defaultStrategy = "v2";
    @JsonProperty
    private boolean singleThreaded = false;
    @JsonProperty
    private int maxIntermediateRows = 50000;
    @JsonProperty
    private int maxResults = 500000;
    @JsonProperty
    private int bufferGrouperMaxSize = Integer.MAX_VALUE;
    @JsonProperty
    private float bufferGrouperMaxLoadFactor = 0.0f;
    @JsonProperty
    private int bufferGrouperInitialBuckets = 0;
    @JsonProperty
    private HumanReadableBytes maxSelectorDictionarySize = HumanReadableBytes.valueOf((long)0L);
    @JsonProperty
    private HumanReadableBytes maxMergingDictionarySize = HumanReadableBytes.valueOf((long)0L);
    @JsonProperty
    private HumanReadableBytes maxOnDiskStorage = HumanReadableBytes.valueOf((int)0);
    @JsonProperty
    private HumanReadableBytes defaultOnDiskStorage = HumanReadableBytes.valueOf((int)-1);
    @JsonProperty
    private boolean forcePushDownLimit = false;
    @JsonProperty
    private boolean applyLimitPushDownToSegment = false;
    @JsonProperty
    private boolean forcePushDownNestedQuery = false;
    @JsonProperty
    private boolean forceHashAggregation = false;
    @JsonProperty
    private int intermediateCombineDegree = 8;
    @JsonProperty
    private int numParallelCombineThreads = 1;
    @JsonProperty
    private boolean mergeThreadLocal = false;
    @JsonProperty
    private boolean vectorize = true;
    @JsonProperty
    private boolean intermediateResultAsMapCompat = false;
    @JsonProperty
    private boolean enableMultiValueUnnesting = true;

    public String getDefaultStrategy() {
        return this.defaultStrategy;
    }

    public boolean isSingleThreaded() {
        return this.singleThreaded;
    }

    public void setSingleThreaded(boolean singleThreaded) {
        this.singleThreaded = singleThreaded;
    }

    public int getMaxIntermediateRows() {
        return this.maxIntermediateRows;
    }

    public void setMaxIntermediateRows(int maxIntermediateRows) {
        this.maxIntermediateRows = maxIntermediateRows;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getBufferGrouperMaxSize() {
        return this.bufferGrouperMaxSize;
    }

    public float getBufferGrouperMaxLoadFactor() {
        return this.bufferGrouperMaxLoadFactor;
    }

    public int getBufferGrouperInitialBuckets() {
        return this.bufferGrouperInitialBuckets;
    }

    long getConfiguredMaxSelectorDictionarySize() {
        return this.maxSelectorDictionarySize.getBytes();
    }

    long getActualMaxSelectorDictionarySize(long maxHeapSize, int numConcurrentQueries) {
        if (this.maxSelectorDictionarySize.getBytes() == 0L) {
            long heapForDictionaries = (long)((double)maxHeapSize * 0.1);
            return Math.max(1L, Math.min(1000000000L, heapForDictionaries / (long)numConcurrentQueries));
        }
        return this.maxSelectorDictionarySize.getBytes();
    }

    public long getActualMaxSelectorDictionarySize(DruidProcessingConfig processingConfig) {
        return this.getActualMaxSelectorDictionarySize(JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes(), processingConfig.getNumMergeBuffers());
    }

    long getConfiguredMaxMergingDictionarySize() {
        return this.maxMergingDictionarySize.getBytes();
    }

    public long getActualMaxMergingDictionarySize(long maxHeapSize, int numConcurrentQueries) {
        if (this.maxMergingDictionarySize.getBytes() == 0L) {
            long heapForDictionaries = (long)((double)maxHeapSize * 0.3);
            return Math.max(1L, Math.min(1000000000L, heapForDictionaries / (long)numConcurrentQueries));
        }
        return this.maxMergingDictionarySize.getBytes();
    }

    public long getActualMaxMergingDictionarySize(DruidProcessingConfig processingConfig) {
        return this.getActualMaxMergingDictionarySize(JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes(), processingConfig.getNumMergeBuffers());
    }

    public HumanReadableBytes getMaxOnDiskStorage() {
        return this.maxOnDiskStorage;
    }

    public HumanReadableBytes getDefaultOnDiskStorage() {
        return this.defaultOnDiskStorage.getBytes() < 0L ? this.getMaxOnDiskStorage() : this.defaultOnDiskStorage;
    }

    public boolean isForcePushDownLimit() {
        return this.forcePushDownLimit;
    }

    public boolean isApplyLimitPushDownToSegment() {
        return this.applyLimitPushDownToSegment;
    }

    public boolean isForceHashAggregation() {
        return this.forceHashAggregation;
    }

    public int getIntermediateCombineDegree() {
        return this.intermediateCombineDegree;
    }

    public int getNumParallelCombineThreads() {
        return this.numParallelCombineThreads;
    }

    public boolean isMergeThreadLocal() {
        return this.mergeThreadLocal;
    }

    public boolean isVectorize() {
        return this.vectorize;
    }

    public boolean isIntermediateResultAsMapCompat() {
        return this.intermediateResultAsMapCompat;
    }

    public boolean isForcePushDownNestedQuery() {
        return this.forcePushDownNestedQuery;
    }

    public boolean isMultiValueUnnestingEnabled() {
        return this.enableMultiValueUnnesting;
    }

    public GroupByQueryConfig withOverrides(GroupByQuery query) {
        GroupByQueryConfig newConfig = new GroupByQueryConfig();
        QueryContext queryContext = query.context();
        newConfig.defaultStrategy = queryContext.getString(CTX_KEY_STRATEGY, this.getDefaultStrategy());
        newConfig.singleThreaded = queryContext.getBoolean(CTX_KEY_IS_SINGLE_THREADED, this.isSingleThreaded());
        newConfig.maxIntermediateRows = Math.min(queryContext.getInt(CTX_KEY_MAX_INTERMEDIATE_ROWS, this.getMaxIntermediateRows()), this.getMaxIntermediateRows());
        newConfig.maxResults = Math.min(queryContext.getInt(CTX_KEY_MAX_RESULTS, this.getMaxResults()), this.getMaxResults());
        newConfig.bufferGrouperMaxSize = Math.min(queryContext.getInt(CTX_KEY_BUFFER_GROUPER_MAX_SIZE, this.getBufferGrouperMaxSize()), this.getBufferGrouperMaxSize());
        newConfig.bufferGrouperMaxLoadFactor = queryContext.getFloat(CTX_KEY_BUFFER_GROUPER_MAX_LOAD_FACTOR, this.getBufferGrouperMaxLoadFactor());
        newConfig.bufferGrouperInitialBuckets = queryContext.getInt(CTX_KEY_BUFFER_GROUPER_INITIAL_BUCKETS, this.getBufferGrouperInitialBuckets());
        newConfig.maxOnDiskStorage = HumanReadableBytes.valueOf((long)Math.min(queryContext.getHumanReadableBytes(CTX_KEY_MAX_ON_DISK_STORAGE, this.getDefaultOnDiskStorage()).getBytes(), this.getMaxOnDiskStorage().getBytes()));
        newConfig.maxSelectorDictionarySize = this.maxSelectorDictionarySize;
        newConfig.maxMergingDictionarySize = this.maxMergingDictionarySize;
        newConfig.forcePushDownLimit = queryContext.getBoolean(CTX_KEY_FORCE_LIMIT_PUSH_DOWN, this.isForcePushDownLimit());
        newConfig.applyLimitPushDownToSegment = queryContext.getBoolean(CTX_KEY_APPLY_LIMIT_PUSH_DOWN_TO_SEGMENT, this.isApplyLimitPushDownToSegment());
        newConfig.forceHashAggregation = queryContext.getBoolean(CTX_KEY_FORCE_HASH_AGGREGATION, this.isForceHashAggregation());
        newConfig.forcePushDownNestedQuery = queryContext.getBoolean(CTX_KEY_FORCE_PUSH_DOWN_NESTED_QUERY, this.isForcePushDownNestedQuery());
        newConfig.intermediateCombineDegree = queryContext.getInt(CTX_KEY_INTERMEDIATE_COMBINE_DEGREE, this.getIntermediateCombineDegree());
        newConfig.numParallelCombineThreads = queryContext.getInt(CTX_KEY_NUM_PARALLEL_COMBINE_THREADS, this.getNumParallelCombineThreads());
        newConfig.mergeThreadLocal = queryContext.getBoolean(CTX_KEY_MERGE_THREAD_LOCAL, this.isMergeThreadLocal());
        newConfig.vectorize = queryContext.getBoolean("vectorize", this.isVectorize());
        newConfig.enableMultiValueUnnesting = queryContext.getBoolean(CTX_KEY_ENABLE_MULTI_VALUE_UNNESTING, this.isMultiValueUnnestingEnabled());
        logger.debug("Override config for GroupBy query %s - %s", new Object[]{query.getId(), newConfig.toString()});
        return newConfig;
    }

    public String toString() {
        return "GroupByQueryConfig{defaultStrategy='" + this.defaultStrategy + '\'' + ", singleThreaded=" + this.singleThreaded + ", maxIntermediateRows=" + this.maxIntermediateRows + ", maxResults=" + this.maxResults + ", bufferGrouperMaxSize=" + this.bufferGrouperMaxSize + ", bufferGrouperMaxLoadFactor=" + this.bufferGrouperMaxLoadFactor + ", bufferGrouperInitialBuckets=" + this.bufferGrouperInitialBuckets + ", maxMergingDictionarySize=" + this.maxMergingDictionarySize + ", maxOnDiskStorage=" + this.maxOnDiskStorage.getBytes() + ", defaultOnDiskStorage=" + this.getDefaultOnDiskStorage().getBytes() + ", forcePushDownLimit=" + this.forcePushDownLimit + ", forceHashAggregation=" + this.forceHashAggregation + ", intermediateCombineDegree=" + this.intermediateCombineDegree + ", numParallelCombineThreads=" + this.numParallelCombineThreads + ", vectorize=" + this.vectorize + ", forcePushDownNestedQuery=" + this.forcePushDownNestedQuery + ", enableMultiValueUnnesting=" + this.enableMultiValueUnnesting + '}';
    }
}

