/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.column.Utf8ValueSetIndex;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class InDimFilter
extends AbstractOptimizableDimFilter
implements Filter {
    private final ValuesSet values;
    private final SortedSet<ByteBuffer> valuesUtf8;
    private final String dimension;
    @Nullable
    private final ExtractionFn extractionFn;
    @Nullable
    private final FilterTuning filterTuning;
    private final DruidPredicateFactory predicateFactory;
    @JsonIgnore
    private final Supplier<byte[]> cacheKeySupplier;

    @JsonCreator
    public InDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="values") ValuesSet values, @JsonProperty(value="extractionFn") @Nullable ExtractionFn extractionFn, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        this(dimension, values, extractionFn, filterTuning, null);
    }

    public InDimFilter(String dimension, Set<String> values) {
        this(dimension, values instanceof ValuesSet ? (ValuesSet)((Object)values) : new ValuesSet(values), null, null, null);
    }

    public InDimFilter(String dimension, Collection<String> values, @Nullable ExtractionFn extractionFn) {
        this(dimension, values instanceof ValuesSet ? (ValuesSet)((Object)values) : new ValuesSet(values), extractionFn, null, null);
    }

    private InDimFilter(String dimension, ValuesSet values, @Nullable ExtractionFn extractionFn, @Nullable FilterTuning filterTuning, @Nullable DruidPredicateFactory predicateFactory) {
        Preconditions.checkNotNull((Object)((Object)values), (Object)"values cannot be null");
        this.values = values;
        if (!NullHandling.sqlCompatible() && values.contains("")) {
            this.values.remove("");
            this.values.add(null);
        }
        this.valuesUtf8 = this.values.toUtf8();
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension cannot be null");
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
        this.predicateFactory = predicateFactory != null ? predicateFactory : new InFilterDruidPredicateFactory(extractionFn, this.values);
        this.cacheKeySupplier = Suppliers.memoize(this::computeCacheKey);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public SortedSet<String> getValues() {
        return this.values;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    public byte[] getCacheKey() {
        return (byte[])this.cacheKeySupplier.get();
    }

    @Override
    public DimFilter optimize() {
        InDimFilter inFilter = this.optimizeLookup();
        if (inFilter.values.isEmpty()) {
            return FalseDimFilter.instance();
        }
        if (inFilter.values.size() == 1) {
            return new SelectorDimFilter(inFilter.dimension, (String)inFilter.values.iterator().next(), inFilter.getExtractionFn(), this.filterTuning);
        }
        return inFilter;
    }

    @Override
    public Filter toFilter() {
        return this;
    }

    @Override
    @Nullable
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null) {
            return null;
        }
        TreeRangeSet retSet = TreeRangeSet.create();
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            String valueEquivalent = NullHandling.nullToEmptyIfNeeded((String)value);
            if (valueEquivalent == null) {
                retSet.add(Range.lessThan((Comparable)((Object)"")));
                continue;
            }
            retSet.add(Range.singleton((Comparable)((Object)valueEquivalent)));
        }
        return retSet;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        if (!Filters.checkFilterTuningUseIndex(this.dimension, selector, this.filterTuning)) {
            return null;
        }
        if (this.extractionFn == null) {
            ColumnIndexSupplier indexSupplier = selector.getIndexSupplier(this.dimension);
            if (indexSupplier == null) {
                return Filters.makeNullIndex(this.predicateFactory.makeStringPredicate().apply(null), selector);
            }
            Utf8ValueSetIndex utf8ValueSetIndex = indexSupplier.as(Utf8ValueSetIndex.class);
            if (utf8ValueSetIndex != null) {
                return utf8ValueSetIndex.forSortedValuesUtf8(this.valuesUtf8);
            }
            StringValueSetIndex stringValueSetIndex = indexSupplier.as(StringValueSetIndex.class);
            if (stringValueSetIndex != null) {
                return stringValueSetIndex.forSortedValues((SortedSet<String>)((Object)this.values));
            }
        }
        return Filters.makePredicateIndex(this.dimension, selector, this.predicateFactory);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.predicateFactory);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.dimension, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.predicateFactory);
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.dimension);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", new Object[]{columnRewrites, this.dimension});
        }
        if (rewriteDimensionTo.equals(this.dimension)) {
            return this;
        }
        return new InDimFilter(rewriteDimensionTo, this.values, this.extractionFn, this.filterTuning, this.predicateFactory);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    public String toString() {
        DimFilter.DimFilterToStringBuilder builder = new DimFilter.DimFilterToStringBuilder();
        return builder.appendDimension(this.dimension, this.extractionFn).append(" IN (").append(Joiner.on((String)", ").join(Iterables.transform((Iterable)((Object)this.values), StringUtils::nullToEmptyNonDruidDataString))).append(")").appendFilterTuning(this.filterTuning).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InDimFilter that = (InDimFilter)o;
        return this.values.equals((Object)that.values) && this.dimension.equals(that.dimension) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.values, this.dimension, this.extractionFn, this.filterTuning});
    }

    private byte[] computeCacheKey() {
        Hasher hasher = Hashing.sha256().newHasher();
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            String v = (String)iterator.next();
            if (v == null) {
                hasher.putInt(-1);
                continue;
            }
            hasher.putInt(v.length());
            hasher.putString((CharSequence)v, StandardCharsets.UTF_8);
        }
        return new CacheKeyBuilder(9).appendString(this.dimension).appendByte((byte)-1).appendByteArray(this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey()).appendByte((byte)-1).appendByteArray(hasher.hash().asBytes()).build();
    }

    private InDimFilter optimizeLookup() {
        if (this.extractionFn instanceof LookupExtractionFn && ((LookupExtractionFn)this.extractionFn).isOptimize()) {
            LookupExtractionFn exFn = (LookupExtractionFn)this.extractionFn;
            LookupExtractor lookup = exFn.getLookup();
            ValuesSet keys = new ValuesSet();
            Iterator iterator = this.values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                String convertedValue = NullHandling.emptyToNullIfNeeded((String)value);
                if (!exFn.isRetainMissingValue() && Objects.equals(convertedValue, exFn.getReplaceMissingValueWith())) {
                    return this;
                }
                keys.addAll(lookup.unapply(convertedValue));
                if (!exFn.isRetainMissingValue() || !NullHandling.isNullOrEquivalent((String)lookup.apply(convertedValue))) continue;
                keys.add(convertedValue);
            }
            if (keys.isEmpty()) {
                return this;
            }
            return new InDimFilter(this.dimension, keys, null, this.filterTuning);
        }
        return this;
    }

    private static Predicate<String> createStringPredicate(Set<String> values) {
        Preconditions.checkNotNull(values, (Object)"values");
        return values::contains;
    }

    private static DruidLongPredicate createLongPredicate(Set<String> values) {
        LongArrayList longs = new LongArrayList(values.size());
        for (String value : values) {
            Long longValue = DimensionHandlerUtils.convertObjectToLong(value);
            if (longValue == null) continue;
            longs.add(longValue.longValue());
        }
        final LongOpenHashSet longHashSet = new LongOpenHashSet((LongCollection)longs);
        final boolean matchNull = values.contains(null);
        return new DruidLongPredicate(){

            @Override
            public boolean applyLong(long n) {
                return longHashSet.contains(n);
            }

            @Override
            public boolean applyNull() {
                return matchNull;
            }
        };
    }

    private static DruidFloatPredicate createFloatPredicate(Set<String> values) {
        IntArrayList floatBits = new IntArrayList(values.size());
        for (String value : values) {
            Float floatValue = DimensionHandlerUtils.convertObjectToFloat(value);
            if (floatValue == null) continue;
            floatBits.add(Float.floatToIntBits(floatValue.floatValue()));
        }
        final IntOpenHashSet floatBitsHashSet = new IntOpenHashSet((IntCollection)floatBits);
        final boolean matchNull = values.contains(null);
        return new DruidFloatPredicate(){

            @Override
            public boolean applyFloat(float n) {
                return floatBitsHashSet.contains(Float.floatToIntBits(n));
            }

            @Override
            public boolean applyNull() {
                return matchNull;
            }
        };
    }

    private static DruidDoublePredicate createDoublePredicate(Set<String> values) {
        LongArrayList doubleBits = new LongArrayList(values.size());
        for (String value : values) {
            Double doubleValue = DimensionHandlerUtils.convertObjectToDouble(value);
            if (doubleValue == null) continue;
            doubleBits.add(Double.doubleToLongBits(doubleValue));
        }
        final LongOpenHashSet doubleBitsHashSet = new LongOpenHashSet((LongCollection)doubleBits);
        final boolean matchNull = values.contains(null);
        return new DruidDoublePredicate(){

            @Override
            public boolean applyDouble(double n) {
                return doubleBitsHashSet.contains(Double.doubleToLongBits(n));
            }

            @Override
            public boolean applyNull() {
                return matchNull;
            }
        };
    }

    public static class ValuesSet
    extends ForwardingSortedSet<String> {
        private final SortedSet<String> values;

        public ValuesSet() {
            this.values = new TreeSet<String>((Comparator<String>)Comparators.naturalNullsFirst());
        }

        public ValuesSet(Collection<String> values) {
            if (values instanceof SortedSet && Comparators.naturalNullsFirst().equals(((SortedSet)values).comparator())) {
                this.values = (SortedSet)values;
            } else {
                this.values = new TreeSet<String>((Comparator<String>)Comparators.naturalNullsFirst());
                this.values.addAll(values);
            }
        }

        public SortedSet<ByteBuffer> toUtf8() {
            TreeSet<ByteBuffer> valuesUtf8 = new TreeSet<ByteBuffer>(ByteBufferUtils.utf8Comparator());
            for (String value : this.values) {
                if (value == null) {
                    valuesUtf8.add(null);
                    continue;
                }
                valuesUtf8.add(ByteBuffer.wrap(StringUtils.toUtf8((String)value)));
            }
            return valuesUtf8;
        }

        protected SortedSet<String> delegate() {
            return this.values;
        }
    }

    @VisibleForTesting
    public static class InFilterDruidPredicateFactory
    implements DruidPredicateFactory {
        private final ExtractionFn extractionFn;
        private final Set<String> values;
        private final Supplier<Predicate<String>> stringPredicateSupplier;
        private final Supplier<DruidLongPredicate> longPredicateSupplier;
        private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
        private final Supplier<DruidDoublePredicate> doublePredicateSupplier;

        public InFilterDruidPredicateFactory(ExtractionFn extractionFn, ValuesSet values) {
            this.extractionFn = extractionFn;
            this.values = values;
            this.stringPredicateSupplier = Suppliers.memoize(() -> InDimFilter.createStringPredicate((Set)((Object)values)));
            this.longPredicateSupplier = Suppliers.memoize(() -> InDimFilter.createLongPredicate((Set)((Object)values)));
            this.floatPredicateSupplier = Suppliers.memoize(() -> InDimFilter.createFloatPredicate((Set)((Object)values)));
            this.doublePredicateSupplier = Suppliers.memoize(() -> InDimFilter.createDoublePredicate((Set)((Object)values)));
        }

        @Override
        public Predicate<String> makeStringPredicate() {
            if (this.extractionFn != null) {
                Predicate stringPredicate = (Predicate)this.stringPredicateSupplier.get();
                return input -> stringPredicate.apply((Object)this.extractionFn.apply((String)input));
            }
            return (Predicate)this.stringPredicateSupplier.get();
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            if (this.extractionFn != null) {
                Predicate stringPredicate = (Predicate)this.stringPredicateSupplier.get();
                return input -> stringPredicate.apply((Object)this.extractionFn.apply(input));
            }
            return (DruidLongPredicate)this.longPredicateSupplier.get();
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            if (this.extractionFn != null) {
                Predicate stringPredicate = (Predicate)this.stringPredicateSupplier.get();
                return input -> stringPredicate.apply((Object)this.extractionFn.apply(Float.valueOf(input)));
            }
            return (DruidFloatPredicate)this.floatPredicateSupplier.get();
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            if (this.extractionFn != null) {
                Predicate stringPredicate = (Predicate)this.stringPredicateSupplier.get();
                return input -> stringPredicate.apply((Object)this.extractionFn.apply(input));
            }
            return (DruidDoublePredicate)this.doublePredicateSupplier.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InFilterDruidPredicateFactory that = (InFilterDruidPredicateFactory)o;
            return Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.values, that.values);
        }

        public int hashCode() {
            return Objects.hash(this.extractionFn, this.values);
        }
    }
}

