/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.nio.ByteBuffer;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.dimension.BaseFilteredDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ForwardingFilteredDimensionSelector;
import org.apache.druid.query.dimension.PredicateFilteredDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdMapping;

public class PrefixFilteredDimensionSpec
extends BaseFilteredDimensionSpec {
    private static final byte CACHE_TYPE_ID = 4;
    private final String prefix;

    public PrefixFilteredDimensionSpec(@JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="prefix") String prefix) {
        super(delegate);
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix must not be null");
    }

    @JsonProperty
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        if (selector == null) {
            return null;
        }
        int selectorCardinality = selector.getValueCardinality();
        if (selectorCardinality < 0 || !selector.nameLookupPossibleInAdvance()) {
            return new PredicateFilteredDimensionSelector(selector, (Predicate<String>)((Predicate)input -> {
                String val = NullHandling.nullToEmptyIfNeeded((String)input);
                return val != null && val.startsWith(this.prefix);
            }));
        }
        IdMapping.Builder builder = IdMapping.Builder.ofUnknownCardinality();
        for (int i = 0; i < selectorCardinality; ++i) {
            String val = NullHandling.nullToEmptyIfNeeded((String)selector.lookupName(i));
            if (val == null || !val.startsWith(this.prefix)) continue;
            builder.addForwardMapping(i);
        }
        return new ForwardingFilteredDimensionSelector(selector, builder.build());
    }

    public byte[] getCacheKey() {
        byte[] delegateCacheKey = this.delegate.getCacheKey();
        byte[] prefixBytes = StringUtils.toUtf8((String)this.prefix);
        return ByteBuffer.allocate(2 + delegateCacheKey.length + prefixBytes.length).put((byte)4).put(delegateCacheKey).put((byte)-1).put(prefixBytes).array();
    }

    @Override
    public DimensionSpec withDimension(String newDimension) {
        return new PrefixFilteredDimensionSpec(this.delegate.withDimension(newDimension), this.prefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrefixFilteredDimensionSpec that = (PrefixFilteredDimensionSpec)o;
        if (!this.delegate.equals(that.delegate)) {
            return false;
        }
        return this.prefix.equals(that.prefix);
    }

    public int hashCode() {
        int result = this.delegate.hashCode();
        result = 31 * result + this.prefix.hashCode();
        return result;
    }

    public String toString() {
        return "PrefixFilteredDimensionSpec{Prefix='" + this.prefix + '\'' + '}';
    }
}

