/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.serde.cell.StorableBuffer;

public class SerializablePairLongStringDeltaEncodedStagedSerde
implements StagedSerde<SerializablePairLongString> {
    private final long minValue;
    private final boolean useIntegerDelta;

    public SerializablePairLongStringDeltaEncodedStagedSerde(long minValue, boolean useIntegerDelta) {
        this.minValue = minValue;
        this.useIntegerDelta = useIntegerDelta;
    }

    @Override
    public StorableBuffer serializeDelayed(final @Nullable SerializablePairLongString value) {
        if (value == null) {
            return StorableBuffer.EMPTY;
        }
        String rhsString = (String)value.rhs;
        final byte[] rhsBytes = StringUtils.toUtf8WithNullToEmpty((String)rhsString);
        return new StorableBuffer(){

            @Override
            public void store(ByteBuffer byteBuffer) {
                Preconditions.checkNotNull((Object)value.lhs, (Object)"Long in SerializablePairLongString must be non-null");
                long delta = (Long)value.lhs - SerializablePairLongStringDeltaEncodedStagedSerde.this.minValue;
                Preconditions.checkState((delta >= 0L || delta == (Long)value.lhs ? 1 : 0) != 0);
                if (SerializablePairLongStringDeltaEncodedStagedSerde.this.useIntegerDelta) {
                    byteBuffer.putInt(Ints.checkedCast((long)delta));
                } else {
                    byteBuffer.putLong(delta);
                }
                byteBuffer.putInt(rhsBytes.length);
                if (rhsBytes.length > 0) {
                    byteBuffer.put(rhsBytes);
                }
            }

            @Override
            public int getSerializedSize() {
                return (SerializablePairLongStringDeltaEncodedStagedSerde.this.useIntegerDelta ? 4 : 8) + 4 + rhsBytes.length;
            }
        };
    }

    @Override
    @Nullable
    public SerializablePairLongString deserialize(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() == 0) {
            return null;
        }
        ByteBuffer readOnlyBuffer = byteBuffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
        long lhs = this.useIntegerDelta ? (long)readOnlyBuffer.getInt() : readOnlyBuffer.getLong();
        lhs += this.minValue;
        int stringSize = readOnlyBuffer.getInt();
        String lastString = null;
        if (stringSize > 0) {
            byte[] stringBytes = new byte[stringSize];
            readOnlyBuffer.get(stringBytes, 0, stringSize);
            lastString = StringUtils.fromUtf8((byte[])stringBytes);
        }
        return new SerializablePairLongString(lhs, lastString);
    }
}

