/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Function;
import java.util.Comparator;
import java.util.List;
import java.util.function.BinaryOperator;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.BySegmentResultValueClass;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.Result;
import org.apache.druid.query.ResultMergeQueryRunner;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.LogicalSegment;

public abstract class QueryToolChest<ResultType, QueryType extends Query<ResultType>> {
    private final JavaType baseResultType;
    private final JavaType bySegmentResultType;

    protected QueryToolChest() {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        TypeReference<ResultType> resultTypeReference = this.getResultTypeReference();
        if (resultTypeReference != null) {
            this.baseResultType = typeFactory.constructType(resultTypeReference);
            this.bySegmentResultType = typeFactory.constructParametrizedType(Result.class, Result.class, new JavaType[]{typeFactory.constructParametrizedType(BySegmentResultValueClass.class, BySegmentResultValueClass.class, new JavaType[]{this.baseResultType})});
        } else {
            this.baseResultType = null;
            this.bySegmentResultType = null;
        }
    }

    public final JavaType getBaseResultType() {
        return this.baseResultType;
    }

    public final JavaType getBySegmentResultType() {
        return this.bySegmentResultType;
    }

    public ObjectMapper decorateObjectMapper(ObjectMapper objectMapper, QueryType query) {
        return objectMapper;
    }

    public QueryRunner<ResultType> mergeResults(QueryRunner<ResultType> runner) {
        return new ResultMergeQueryRunner<ResultType>(runner, this::createResultComparator, this::createMergeFn);
    }

    @Nullable
    public BinaryOperator<ResultType> createMergeFn(Query<ResultType> query) {
        return null;
    }

    public Comparator<ResultType> createResultComparator(Query<ResultType> query) {
        throw new UOE("%s doesn't provide a result comparator", new Object[]{query.getClass().getName()});
    }

    public abstract QueryMetrics<? super QueryType> makeMetrics(QueryType var1);

    public abstract Function<ResultType, ResultType> makePreComputeManipulatorFn(QueryType var1, MetricManipulationFn var2);

    public Function<ResultType, ResultType> makePostComputeManipulatorFn(QueryType query, MetricManipulationFn fn) {
        return this.makePreComputeManipulatorFn(query, fn);
    }

    public abstract TypeReference<ResultType> getResultTypeReference();

    @Nullable
    public <T> CacheStrategy<ResultType, T, QueryType> getCacheStrategy(QueryType query) {
        return null;
    }

    public QueryRunner<ResultType> preMergeQueryDecoration(QueryRunner<ResultType> runner) {
        return runner;
    }

    public QueryRunner<ResultType> postMergeQueryDecoration(QueryRunner<ResultType> runner) {
        return runner;
    }

    public <T extends LogicalSegment> List<T> filterSegments(QueryType query, List<T> segments) {
        return segments;
    }

    public boolean canPerformSubquery(Query<?> subquery) {
        return false;
    }

    public RowSignature resultArraySignature(QueryType query) {
        throw new UOE("Query type '%s' does not support returning results as arrays", new Object[]{query.getType()});
    }

    public Sequence<Object[]> resultsAsArrays(QueryType query, Sequence<ResultType> resultSequence) {
        throw new UOE("Query type '%s' does not support returning results as arrays", new Object[]{query.getType()});
    }
}

