/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.jackson.AggregatorsModule;
import org.apache.druid.jackson.AppendableIndexModule;
import org.apache.druid.jackson.DruidDefaultSerializersModule;
import org.apache.druid.jackson.GranularityModule;
import org.apache.druid.jackson.SegmentizerModule;
import org.apache.druid.jackson.StringComparatorModule;
import org.apache.druid.java.util.common.StringUtils;

public class DefaultObjectMapper
extends ObjectMapper {
    public DefaultObjectMapper() {
        this(null, null);
    }

    public DefaultObjectMapper(String serviceName) {
        this(null, serviceName);
    }

    public DefaultObjectMapper(DefaultObjectMapper mapper) {
        super((ObjectMapper)mapper);
    }

    public DefaultObjectMapper(JsonFactory factory, @Nullable String serviceName) {
        super(factory);
        this.registerModule((Module)new DruidDefaultSerializersModule());
        this.registerModule((Module)new GuavaModule());
        this.registerModule((Module)new GranularityModule());
        this.registerModule((Module)new AggregatorsModule());
        this.registerModule((Module)new StringComparatorModule());
        this.registerModule((Module)new SegmentizerModule());
        this.registerModule((Module)new AppendableIndexModule());
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.configure(MapperFeature.AUTO_DETECT_GETTERS, false);
        this.configure(MapperFeature.AUTO_DETECT_FIELDS, false);
        this.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false);
        this.configure(MapperFeature.AUTO_DETECT_SETTERS, false);
        this.configure(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS, false);
        this.configure(SerializationFeature.INDENT_OUTPUT, false);
        this.configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, false);
        this.addHandler(new DefaultDeserializationProblemHandler(serviceName));
    }

    public ObjectMapper copy() {
        return new DefaultObjectMapper(this);
    }

    static class DefaultDeserializationProblemHandler
    extends DeserializationProblemHandler {
        @Nullable
        private final String serviceName;

        public DefaultDeserializationProblemHandler(@Nullable String serviceName) {
            this.serviceName = serviceName;
        }

        @Nullable
        @VisibleForTesting
        String getServiceName() {
            return this.serviceName;
        }

        public JavaType handleUnknownTypeId(DeserializationContext ctxt, JavaType baseType, String subTypeId, TypeIdResolver idResolver, String failureMsg) throws IOException {
            String serviceMsg = this.serviceName == null ? "" : StringUtils.format((String)" on '%s' service", (Object[])new Object[]{this.serviceName});
            String msg = StringUtils.format((String)"Please make sure to load all the necessary extensions and jars with type '%s'%s. Could not resolve type id '%s' as a subtype of %s", (Object[])new Object[]{subTypeId, serviceMsg, subTypeId, ClassUtil.getTypeDescription((JavaType)baseType)});
            String extraFailureMsg = failureMsg == null ? msg : msg + " " + failureMsg;
            throw InvalidTypeIdException.from((JsonParser)ctxt.getParser(), (String)extraFailureMsg, (JavaType)baseType, (String)subTypeId);
        }
    }
}

