/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.base.Predicate;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.IndexedInts;

public class MultiColumnSelectorFactory
implements ColumnSelectorFactory {
    private final List<Supplier<ColumnSelectorFactory>> factorySuppliers;
    private final ColumnInspector columnInspector;
    private int currentFactory = 0;

    public MultiColumnSelectorFactory(List<Supplier<ColumnSelectorFactory>> factorySuppliers, ColumnInspector columnInspector) {
        this.factorySuppliers = factorySuppliers;
        this.columnInspector = columnInspector;
    }

    public void setCurrentFactory(int currentFactory) {
        this.currentFactory = currentFactory;
    }

    @Override
    public DimensionSelector makeDimensionSelector(final DimensionSpec dimensionSpec) {
        return new DimensionSelector(){
            private final ColumnSelectorFactory[] delegateFactories;
            private final DimensionSelector[] delegateSelectors;
            {
                this.delegateFactories = new ColumnSelectorFactory[MultiColumnSelectorFactory.this.factorySuppliers.size()];
                this.delegateSelectors = new DimensionSelector[MultiColumnSelectorFactory.this.factorySuppliers.size()];
            }

            @Override
            public IndexedInts getRow() {
                return this.populateDelegate().getRow();
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
            }

            @Override
            public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
            }

            @Override
            @Nullable
            public Object getObject() {
                return this.populateDelegate().getObject();
            }

            @Override
            public Class<?> classOfObject() {
                return this.populateDelegate().classOfObject();
            }

            @Override
            public int getValueCardinality() {
                return -1;
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return this.populateDelegate().lookupName(id);
            }

            @Override
            @Nullable
            public ByteBuffer lookupNameUtf8(int id) {
                return this.populateDelegate().lookupNameUtf8(id);
            }

            @Override
            public boolean supportsLookupNameUtf8() {
                return this.populateDelegate().supportsLookupNameUtf8();
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return false;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            private DimensionSelector populateDelegate() {
                ColumnSelectorFactory factory = (ColumnSelectorFactory)((Supplier)MultiColumnSelectorFactory.this.factorySuppliers.get(MultiColumnSelectorFactory.this.currentFactory)).get();
                if (factory != this.delegateFactories[MultiColumnSelectorFactory.this.currentFactory]) {
                    this.delegateSelectors[((MultiColumnSelectorFactory)MultiColumnSelectorFactory.this).currentFactory] = factory.makeDimensionSelector(dimensionSpec);
                    this.delegateFactories[((MultiColumnSelectorFactory)MultiColumnSelectorFactory.this).currentFactory] = factory;
                }
                return this.delegateSelectors[MultiColumnSelectorFactory.this.currentFactory];
            }
        };
    }

    @Override
    public ColumnValueSelector makeColumnValueSelector(final String columnName) {
        return new ColumnValueSelector(){
            private final ColumnSelectorFactory[] delegateFactories;
            private final ColumnValueSelector[] delegateSelectors;
            {
                this.delegateFactories = new ColumnSelectorFactory[MultiColumnSelectorFactory.this.factorySuppliers.size()];
                this.delegateSelectors = new ColumnValueSelector[MultiColumnSelectorFactory.this.factorySuppliers.size()];
            }

            @Override
            public double getDouble() {
                return this.populateDelegate().getDouble();
            }

            @Override
            public float getFloat() {
                return this.populateDelegate().getFloat();
            }

            @Override
            public long getLong() {
                return this.populateDelegate().getLong();
            }

            @Override
            public boolean isNull() {
                return this.populateDelegate().isNull();
            }

            @Override
            @Nullable
            public Object getObject() {
                return this.populateDelegate().getObject();
            }

            @Override
            public Class classOfObject() {
                return this.populateDelegate().classOfObject();
            }

            private ColumnValueSelector<?> populateDelegate() {
                ColumnSelectorFactory factory = (ColumnSelectorFactory)((Supplier)MultiColumnSelectorFactory.this.factorySuppliers.get(MultiColumnSelectorFactory.this.currentFactory)).get();
                if (factory != this.delegateFactories[MultiColumnSelectorFactory.this.currentFactory]) {
                    this.delegateSelectors[((MultiColumnSelectorFactory)MultiColumnSelectorFactory.this).currentFactory] = factory.makeColumnValueSelector(columnName);
                    this.delegateFactories[((MultiColumnSelectorFactory)MultiColumnSelectorFactory.this).currentFactory] = factory;
                }
                return this.delegateSelectors[MultiColumnSelectorFactory.this.currentFactory];
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.columnInspector.getColumnCapabilities(column);
    }
}

