/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.segment.row.ReadableFrameRowPointer;

public class RowMemoryFieldPointer
implements ReadableFieldPointer {
    private final Memory memory;
    private final ReadableFrameRowPointer rowPointer;
    private final int fieldNumber;
    private final int fieldCount;

    public RowMemoryFieldPointer(Memory memory, ReadableFrameRowPointer rowPointer, int fieldNumber, int fieldCount) {
        this.memory = memory;
        this.rowPointer = rowPointer;
        this.fieldNumber = fieldNumber;
        this.fieldCount = fieldCount;
    }

    @Override
    public long position() {
        if (this.fieldNumber == 0) {
            return this.rowPointer.position() + 4L * (long)this.fieldCount;
        }
        return this.rowPointer.position() + (long)this.memory.getInt(this.rowPointer.position() + 4L * (long)(this.fieldNumber - 1));
    }
}

