/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.segment.BaseFloatColumnValueSelector;

public class FloatFieldWriter
implements FieldWriter {
    public static final int SIZE = 5;
    public static final byte NULL_BYTE = 0;
    public static final byte NOT_NULL_BYTE = 1;
    private final BaseFloatColumnValueSelector selector;

    public FloatFieldWriter(BaseFloatColumnValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public long writeTo(WritableMemory memory, long position, long maxSize) {
        if (maxSize < 5L) {
            return -1L;
        }
        if (this.selector.isNull()) {
            memory.putByte(position, (byte)0);
            memory.putInt(position + 1L, FloatFieldWriter.transform(0.0f));
        } else {
            memory.putByte(position, (byte)1);
            memory.putInt(position + 1L, FloatFieldWriter.transform(this.selector.getFloat()));
        }
        return 5L;
    }

    @Override
    public void close() {
    }

    public static int transform(float n) {
        int bits = Float.floatToIntBits(n);
        int mask = (bits & Integer.MIN_VALUE) >> 8 | Integer.MIN_VALUE;
        return Integer.reverseBytes(bits ^ mask);
    }

    public static float detransform(int bits) {
        int reversedBits = Integer.reverseBytes(bits);
        int mask = ((reversedBits ^ Integer.MIN_VALUE) & Integer.MIN_VALUE) >> 8 | Integer.MIN_VALUE;
        return Float.intBitsToFloat(reversedBits ^ mask);
    }
}

