/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.io.IOUtils;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableByteChunksFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;

public class ReadableInputStreamFrameChannel
implements ReadableFrameChannel {
    private final InputStream inputStream;
    private final ReadableByteChunksFrameChannel delegate;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final byte[] buffer = new byte[8192];
    @GuardedBy(value="lock")
    private long totalInputStreamBytesRead = 0L;
    @GuardedBy(value="lock")
    private boolean inputStreamFinished = false;
    @GuardedBy(value="lock")
    private boolean inputStreamError = false;
    private volatile boolean keepReading = true;
    private final Object readMonitor = new Object();
    private final ExecutorService executorService;
    private static final int BASE_SLEEP_MILLIS = 100;
    private static final int MAX_SLEEP_MILLIS = 2000;

    private ReadableInputStreamFrameChannel(InputStream inputStream, ReadableByteChunksFrameChannel delegate, ExecutorService executorService) {
        this.inputStream = inputStream;
        this.delegate = delegate;
        this.executorService = executorService;
    }

    public static ReadableInputStreamFrameChannel open(InputStream inputStream, String id, ExecutorService executorService) {
        ReadableInputStreamFrameChannel channel = new ReadableInputStreamFrameChannel(inputStream, ReadableByteChunksFrameChannel.create(id), executorService);
        channel.startReading();
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.isFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canRead() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.canRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame read() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<?> readabilityFuture() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.readabilityFuture();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.inputStreamFinished = true;
            this.delegate.close();
            IOUtils.closeQuietly((InputStream)this.inputStream);
        }
    }

    private void startReading() {
        this.executorService.submit(() -> {
            int nTry = 1;
            while (true) {
                Object object;
                if (!this.keepReading) {
                    try {
                        object = this.readMonitor;
                        synchronized (object) {
                            if (!this.keepReading) {
                                this.readMonitor.wait(ReadableInputStreamFrameChannel.nextRetrySleepMillis(nTry));
                            }
                        }
                        object = this.lock;
                        synchronized (object) {
                            if (this.inputStreamFinished || this.inputStreamError || this.delegate.isErrorOrFinished()) {
                                return;
                            }
                        }
                        ++nTry;
                    }
                    catch (InterruptedException e) {
                        IOUtils.closeQuietly((InputStream)this.inputStream);
                        throw new ISE((Throwable)e, Thread.currentThread().getName() + "interrupted", new Object[0]);
                    }
                }
                object = this.lock;
                synchronized (object) {
                    nTry = 1;
                    if (this.inputStreamFinished) {
                        this.delegate.doneWriting();
                        break;
                    }
                    try {
                        int bytesRead = this.inputStream.read(this.buffer);
                        if (bytesRead == -1) {
                            this.inputStreamFinished = true;
                            this.delegate.doneWriting();
                            break;
                        }
                        ListenableFuture<?> backpressureFuture = this.delegate.addChunk(Arrays.copyOfRange(this.buffer, 0, bytesRead));
                        this.totalInputStreamBytesRead += (long)bytesRead;
                        if (backpressureFuture != null) {
                            this.keepReading = false;
                            backpressureFuture.addListener(() -> {
                                Object object = this.readMonitor;
                                synchronized (object) {
                                    this.keepReading = true;
                                    this.readMonitor.notify();
                                }
                            }, (Executor)Execs.directExecutor());
                        } else {
                            this.keepReading = true;
                        }
                    }
                    catch (Exception e) {
                        long currentStreamOffset = this.totalInputStreamBytesRead;
                        this.delegate.setError((Throwable)new ISE((Throwable)e, "Found error while reading input stream at %d", new Object[]{currentStreamOffset}));
                        this.inputStreamError = true;
                        IOUtils.closeQuietly((InputStream)this.inputStream);
                        break;
                    }
                }
            }
        });
    }

    private static long nextRetrySleepMillis(int nTry) {
        double fuzzyMultiplier = Math.min(Math.max(1.0 + 0.2 * ThreadLocalRandom.current().nextGaussian(), 0.0), 2.0);
        long sleepMillis = (long)(Math.min(2000.0, 100.0 * Math.pow(2.0, nTry - 1)) * fuzzyMultiplier);
        return sleepMillis;
    }
}

