/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.spatial.search;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableNode;
import org.apache.druid.collections.spatial.ImmutablePoint;
import org.apache.druid.collections.spatial.search.Bound;
import org.apache.druid.collections.spatial.search.SearchStrategy;

public class GutmanSearchStrategy
implements SearchStrategy {
    @Override
    public Iterable<ImmutableBitmap> search(ImmutableNode node, Bound bound) {
        if (bound.getLimit() > 0) {
            return Iterables.transform(this.breadthFirstSearch(node, bound), (Function)new Function<ImmutableNode, ImmutableBitmap>(){

                public ImmutableBitmap apply(ImmutableNode immutableNode) {
                    return immutableNode.getImmutableBitmap();
                }
            });
        }
        return Iterables.transform(this.depthFirstSearch(node, bound), (Function)new Function<ImmutablePoint, ImmutableBitmap>(){

            public ImmutableBitmap apply(ImmutablePoint immutablePoint) {
                return immutablePoint.getImmutableBitmap();
            }
        });
    }

    public Iterable<ImmutablePoint> depthFirstSearch(ImmutableNode node, final Bound bound) {
        if (node.isLeaf()) {
            return bound.filter(Iterables.transform(node.getChildren(), (Function)new Function<ImmutableNode, ImmutablePoint>(){

                public ImmutablePoint apply(ImmutableNode tNode) {
                    return new ImmutablePoint(tNode);
                }
            }));
        }
        return Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.filter(node.getChildren(), (Predicate)new Predicate<ImmutableNode>(){

            public boolean apply(ImmutableNode child) {
                return bound.overlaps(child);
            }
        }), (Function)new Function<ImmutableNode, Iterable<ImmutablePoint>>(){

            public Iterable<ImmutablePoint> apply(ImmutableNode child) {
                return GutmanSearchStrategy.this.depthFirstSearch(child, bound);
            }
        }));
    }

    public Iterable<ImmutableNode> breadthFirstSearch(ImmutableNode node, final Bound bound) {
        if (node.isLeaf()) {
            return Iterables.filter(node.getChildren(), (Predicate)new Predicate<ImmutableNode>(){

                public boolean apply(ImmutableNode immutableNode) {
                    return bound.contains(immutableNode.getMinCoordinates());
                }
            });
        }
        return this.breadthFirstSearch(node.getChildren(), bound, 0);
    }

    public Iterable<ImmutableNode> breadthFirstSearch(Iterable<ImmutableNode> nodes, final Bound bound, int total) {
        Iterable points = Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.filter(nodes, (Predicate)new Predicate<ImmutableNode>(){

            public boolean apply(ImmutableNode immutableNode) {
                return immutableNode.isLeaf();
            }
        }), (Function)new Function<ImmutableNode, Iterable<ImmutableNode>>(){

            public Iterable<ImmutableNode> apply(ImmutableNode immutableNode) {
                return Iterables.filter(immutableNode.getChildren(), (Predicate)new Predicate<ImmutableNode>(){

                    public boolean apply(ImmutableNode immutableNode) {
                        return bound.contains(immutableNode.getMinCoordinates());
                    }
                });
            }
        }));
        Iterable overlappingNodes = Iterables.filter(nodes, (Predicate)new Predicate<ImmutableNode>(){

            public boolean apply(ImmutableNode immutableNode) {
                return !immutableNode.isLeaf() && bound.overlaps(immutableNode);
            }
        });
        int totalPoints = Iterables.size((Iterable)points);
        int totalOverlap = Iterables.size((Iterable)overlappingNodes);
        if (totalOverlap == 0 || totalPoints + totalOverlap + total >= bound.getLimit()) {
            return Iterables.concat((Iterable)points, (Iterable)overlappingNodes);
        }
        return Iterables.concat((Iterable)points, this.breadthFirstSearch(Iterables.concat((Iterable)Iterables.transform((Iterable)overlappingNodes, (Function)new Function<ImmutableNode, Iterable<ImmutableNode>>(){

            public Iterable<ImmutableNode> apply(ImmutableNode immutableNode) {
                return immutableNode.getChildren();
            }
        })), bound, totalPoints));
    }
}

