/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;

public class NlsString
implements Comparable<NlsString>,
Cloneable {
    private static final LoadingCache<Pair<ByteString, Charset>, String> DECODE_MAP = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<Pair<ByteString, Charset>, String>(){

        public String load(@Nonnull Pair<ByteString, Charset> key) {
            Charset charset = (Charset)key.right;
            CharsetDecoder decoder = charset.newDecoder();
            byte[] bytes = ((ByteString)key.left).getBytes();
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            try {
                return decoder.decode(buffer).toString();
            }
            catch (CharacterCodingException ex) {
                throw Static.RESOURCE.charsetEncoding(new String(bytes, Charset.defaultCharset()), charset.name()).ex();
            }
        }
    });
    private final String stringValue;
    private final ByteString bytesValue;
    private final String charsetName;
    private final Charset charset;
    private final SqlCollation collation;

    public NlsString(ByteString bytesValue, String charsetName, SqlCollation collation) {
        this(null, Objects.requireNonNull(bytesValue), Objects.requireNonNull(charsetName), collation);
    }

    public NlsString(String stringValue, String charsetName, SqlCollation collation) {
        this(Objects.requireNonNull(stringValue), null, charsetName, collation);
    }

    private NlsString(String stringValue, ByteString bytesValue, String charsetName, SqlCollation collation) {
        if (charsetName != null) {
            this.charsetName = charsetName.toUpperCase(Locale.ROOT);
            this.charset = SqlUtil.getCharset(charsetName);
        } else {
            this.charsetName = null;
            this.charset = null;
        }
        if (stringValue != null == (bytesValue != null)) {
            throw new IllegalArgumentException("Specify stringValue or bytesValue");
        }
        if (bytesValue != null) {
            if (charsetName == null) {
                throw new IllegalArgumentException("Bytes value requires charset");
            }
            SqlUtil.validateCharset(bytesValue, this.charset);
        } else if (this.charsetName != null && (this.charsetName.equals("LATIN1") || this.charsetName.equals("ISO-8859-1")) && !this.charset.newEncoder().canEncode(stringValue)) {
            throw Static.RESOURCE.charsetEncoding(stringValue, this.charset.name()).ex();
        }
        this.collation = collation;
        this.stringValue = stringValue;
        this.bytesValue = bytesValue;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public int hashCode() {
        return Objects.hash(this.stringValue, this.bytesValue, this.charsetName, this.collation);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof NlsString && Objects.equals(this.stringValue, ((NlsString)obj).stringValue) && Objects.equals(this.bytesValue, ((NlsString)obj).bytesValue) && Objects.equals(this.charsetName, ((NlsString)obj).charsetName) && Objects.equals(this.collation, ((NlsString)obj).collation);
    }

    @Override
    public int compareTo(NlsString other) {
        return this.getValue().compareTo(other.getValue());
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public SqlCollation getCollation() {
        return this.collation;
    }

    public String getValue() {
        if (this.stringValue == null) {
            assert (this.bytesValue != null);
            return (String)DECODE_MAP.getUnchecked(Pair.of(this.bytesValue, this.charset));
        }
        return this.stringValue;
    }

    public NlsString rtrim() {
        String trimmed = SqlFunctions.rtrim(this.getValue());
        if (!trimmed.equals(this.getValue())) {
            return new NlsString(trimmed, this.charsetName, this.collation);
        }
        return this;
    }

    public String asSql(boolean prefix, boolean suffix) {
        return this.asSql(prefix, suffix, AnsiSqlDialect.DEFAULT);
    }

    public String asSql(boolean prefix, boolean suffix, SqlDialect dialect) {
        StringBuilder ret = new StringBuilder();
        dialect.quoteStringLiteral(ret, prefix ? this.charsetName : null, this.getValue());
        return ret.toString();
    }

    public String toString() {
        return this.asSql(true, true);
    }

    public static NlsString concat(List<NlsString> args) {
        if (args.size() < 2) {
            return args.get(0);
        }
        String charSetName = args.get((int)0).charsetName;
        SqlCollation collation = args.get((int)0).collation;
        int length = args.get(0).getValue().length();
        for (int i = 1; i < args.size(); ++i) {
            NlsString arg = args.get(i);
            length += arg.getValue().length();
            if (arg.charsetName != null && !arg.charsetName.equals(charSetName)) {
                throw new IllegalArgumentException("mismatched charsets");
            }
            if (arg.collation == null || arg.collation.equals(collation)) continue;
            throw new IllegalArgumentException("mismatched collations");
        }
        StringBuilder sb = new StringBuilder(length);
        for (NlsString arg : args) {
            sb.append(arg.getValue());
        }
        return new NlsString(sb.toString(), charSetName, collation);
    }

    public NlsString copy(String value) {
        return new NlsString(value, this.charsetName, this.collation);
    }

    public ByteString getValueBytes() {
        return this.bytesValue;
    }
}

