/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;

public class RexShuttle
implements RexVisitor<RexNode> {
    @Override
    public RexNode visitOver(RexOver over) {
        boolean[] update = new boolean[]{false};
        List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)over.operands, update);
        RexWindow window = this.visitWindow(over.getWindow());
        if (update[0] || window != over.getWindow()) {
            return new RexOver(over.getType(), over.getAggOperator(), clonedOperands, window, over.isDistinct(), over.ignoreNulls());
        }
        return over;
    }

    public RexWindow visitWindow(RexWindow window) {
        boolean[] update = new boolean[]{false};
        List<RexFieldCollation> clonedOrderKeys = this.visitFieldCollations((List<RexFieldCollation>)window.orderKeys, update);
        List<RexNode> clonedPartitionKeys = this.visitList((List<? extends RexNode>)window.partitionKeys, update);
        RexWindowBound lowerBound = window.getLowerBound().accept(this);
        RexWindowBound upperBound = window.getUpperBound().accept(this);
        if (update[0] || lowerBound != window.getLowerBound() && lowerBound != null || upperBound != window.getUpperBound() && upperBound != null) {
            return new RexWindow(clonedPartitionKeys, clonedOrderKeys, lowerBound, upperBound, window.isRows());
        }
        return window;
    }

    @Override
    public RexNode visitSubQuery(RexSubQuery subQuery) {
        boolean[] update = new boolean[]{false};
        List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)subQuery.operands, update);
        if (update[0]) {
            return subQuery.clone(subQuery.getType(), (List)clonedOperands);
        }
        return subQuery;
    }

    @Override
    public RexNode visitTableInputRef(RexTableInputRef ref) {
        return ref;
    }

    @Override
    public RexNode visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        return fieldRef;
    }

    @Override
    public RexNode visitCall(RexCall call) {
        boolean[] update = new boolean[]{false};
        List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)call.operands, update);
        if (update[0]) {
            return call.clone(call.getType(), clonedOperands);
        }
        return call;
    }

    protected RexNode[] visitArray(RexNode[] exprs, boolean[] update) {
        RexNode[] clonedOperands = new RexNode[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            RexNode operand = exprs[i];
            RexNode clonedOperand = operand.accept(this);
            if (clonedOperand != operand && update != null) {
                update[0] = true;
            }
            clonedOperands[i] = clonedOperand;
        }
        return clonedOperands;
    }

    protected List<RexNode> visitList(List<? extends RexNode> exprs, boolean[] update) {
        ImmutableList.Builder clonedOperands = ImmutableList.builder();
        for (RexNode rexNode : exprs) {
            RexNode clonedOperand = rexNode.accept(this);
            if (clonedOperand != rexNode && update != null) {
                update[0] = true;
            }
            clonedOperands.add((Object)clonedOperand);
        }
        return clonedOperands.build();
    }

    public void visitList(List<? extends RexNode> exprs, List<RexNode> outExprs) {
        for (RexNode rexNode : exprs) {
            outExprs.add(rexNode.accept(this));
        }
    }

    protected List<RexFieldCollation> visitFieldCollations(List<RexFieldCollation> collations, boolean[] update) {
        ImmutableList.Builder clonedOperands = ImmutableList.builder();
        for (RexFieldCollation collation : collations) {
            RexNode clonedOperand = ((RexNode)collation.left).accept(this);
            if (clonedOperand != collation.left && update != null) {
                update[0] = true;
                collation = new RexFieldCollation(clonedOperand, (Set)collation.right);
            }
            clonedOperands.add((Object)collation);
        }
        return clonedOperands.build();
    }

    @Override
    public RexNode visitCorrelVariable(RexCorrelVariable variable) {
        return variable;
    }

    @Override
    public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
        RexNode after;
        RexNode before = fieldAccess.getReferenceExpr();
        if (before == (after = before.accept(this))) {
            return fieldAccess;
        }
        return new RexFieldAccess(after, fieldAccess.getField());
    }

    @Override
    public RexNode visitInputRef(RexInputRef inputRef) {
        return inputRef;
    }

    @Override
    public RexNode visitLocalRef(RexLocalRef localRef) {
        return localRef;
    }

    @Override
    public RexNode visitLiteral(RexLiteral literal) {
        return literal;
    }

    @Override
    public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
        return dynamicParam;
    }

    @Override
    public RexNode visitRangeRef(RexRangeRef rangeRef) {
        return rangeRef;
    }

    public final <T extends RexNode> boolean mutate(List<T> exprList) {
        int changeCount = 0;
        for (int i = 0; i < exprList.size(); ++i) {
            RexNode expr2;
            RexNode expr = (RexNode)exprList.get(i);
            if (expr == (expr2 = this.apply(expr))) continue;
            ++changeCount;
            exprList.set(i, expr2);
        }
        return changeCount > 0;
    }

    public final <T extends RexNode> List<T> apply(List<T> exprList) {
        if (exprList == null) {
            return null;
        }
        ArrayList<T> list2 = new ArrayList<T>(exprList);
        if (this.mutate(list2)) {
            return list2;
        }
        return exprList;
    }

    public final Iterable<RexNode> apply(Iterable<? extends RexNode> iterable) {
        return Iterables.transform(iterable, t -> t == null ? null : t.accept(this));
    }

    public final RexNode apply(RexNode expr) {
        return expr == null ? null : expr.accept(this);
    }
}

