/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;

public abstract class Correlate
extends BiRel {
    protected final CorrelationId correlationId;
    protected final ImmutableBitSet requiredColumns;
    protected final JoinRelType joinType;

    protected Correlate(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        super(cluster, traitSet, left, right);
        assert (!joinType.generatesNullsOnLeft()) : "Correlate has invalid join type " + (Object)((Object)joinType);
        this.joinType = Objects.requireNonNull(joinType);
        this.correlationId = Objects.requireNonNull(correlationId);
        this.requiredColumns = Objects.requireNonNull(requiredColumns);
    }

    public Correlate(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInputs().get(0), input.getInputs().get(1), new CorrelationId((Integer)input.get("correlationId")), input.getBitSet("requiredColumns"), input.getEnum("joinType", JoinRelType.class));
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        return super.isValid(litmus, context) && RelOptUtil.notContainsCorrelation(this.left, this.correlationId, litmus);
    }

    @Override
    public Correlate copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return this.copy(traitSet, inputs.get(0), inputs.get(1), this.correlationId, this.requiredColumns, this.joinType);
    }

    public abstract Correlate copy(RelTraitSet var1, RelNode var2, RelNode var3, CorrelationId var4, ImmutableBitSet var5, JoinRelType var6);

    public JoinRelType getJoinType() {
        return this.joinType;
    }

    @Override
    protected RelDataType deriveRowType() {
        switch (this.joinType) {
            case LEFT: 
            case INNER: {
                return SqlValidatorUtil.deriveJoinRowType(this.left.getRowType(), this.right.getRowType(), this.joinType, this.getCluster().getTypeFactory(), null, (List<RelDataTypeField>)ImmutableList.of());
            }
            case ANTI: 
            case SEMI: {
                return this.left.getRowType();
            }
        }
        throw new IllegalStateException("Unknown join type " + (Object)((Object)this.joinType));
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("correlation", this.correlationId).item("joinType", this.joinType.lowerName).item("requiredColumns", this.requiredColumns.toString());
    }

    public CorrelationId getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public String getCorrelVariable() {
        return this.correlationId.getName();
    }

    public ImmutableBitSet getRequiredColumns() {
        return this.requiredColumns;
    }

    @Override
    public Set<CorrelationId> getVariablesSet() {
        return ImmutableSet.of((Object)this.correlationId);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        double rightRowCount = this.right.estimateRowCount(mq);
        double leftRowCount = this.left.estimateRowCount(mq);
        if (Double.isInfinite(leftRowCount) || Double.isInfinite(rightRowCount)) {
            return planner.getCostFactory().makeInfiniteCost();
        }
        Double restartCount = mq.getRowCount(this.getLeft());
        RelOptCost rightCost = planner.getCost(this.getRight(), mq);
        RelOptCost rescanCost = rightCost.multiplyBy(Math.max(1.0, restartCount - 1.0));
        return planner.getCostFactory().makeCost(rowCount + leftRowCount, 0.0, 0.0).plus(rescanCost);
    }
}

