/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.security.basic.BasicAuthDBConfig;
import org.apache.druid.security.basic.BasicAuthUtils;
import org.apache.druid.security.basic.BasicSecurityAuthenticationException;
import org.apache.druid.security.basic.authentication.db.cache.BasicAuthenticatorCacheManager;
import org.apache.druid.security.basic.authentication.validator.CredentialsValidator;
import org.apache.druid.security.basic.authentication.validator.MetadataStoreCredentialsValidator;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authenticator;

@JsonTypeName(value="basic")
public class BasicHTTPAuthenticator
implements Authenticator {
    private static final Logger LOG = new Logger(BasicHTTPAuthenticator.class);
    private final String name;
    private final String authorizerName;
    private final BasicAuthDBConfig dbConfig;
    private final CredentialsValidator credentialsValidator;
    private final boolean skipOnFailure;

    @JsonCreator
    public BasicHTTPAuthenticator(@JacksonInject Provider<BasicAuthenticatorCacheManager> cacheManager, @JsonProperty(value="name") String name, @JsonProperty(value="authorizerName") String authorizerName, @JsonProperty(value="initialAdminPassword") PasswordProvider initialAdminPassword, @JsonProperty(value="initialInternalClientPassword") PasswordProvider initialInternalClientPassword, @JsonProperty(value="enableCacheNotifications") Boolean enableCacheNotifications, @JsonProperty(value="cacheNotificationTimeout") Long cacheNotificationTimeout, @JsonProperty(value="credentialIterations") Integer credentialIterations, @JsonProperty(value="skipOnFailure") Boolean skipOnFailure, @JsonProperty(value="credentialsValidator") CredentialsValidator credentialsValidator) {
        this.name = name;
        this.authorizerName = authorizerName;
        this.dbConfig = new BasicAuthDBConfig(initialAdminPassword, initialInternalClientPassword, null, null, null, enableCacheNotifications == null ? true : enableCacheNotifications, cacheNotificationTimeout == null ? 5000L : cacheNotificationTimeout, credentialIterations == null ? 10000 : credentialIterations);
        this.credentialsValidator = credentialsValidator == null ? new MetadataStoreCredentialsValidator(cacheManager) : credentialsValidator;
        this.skipOnFailure = skipOnFailure == null ? false : skipOnFailure;
    }

    public Filter getFilter() {
        return new BasicHTTPAuthenticationFilter();
    }

    public String getAuthChallengeHeader() {
        return "Basic";
    }

    @Nullable
    public AuthenticationResult authenticateJDBCContext(Map<String, Object> context) {
        String user = (String)context.get("user");
        String password = (String)context.get("password");
        if (user == null || password == null) {
            return null;
        }
        return this.credentialsValidator.validateCredentials(this.name, this.authorizerName, user, password.toCharArray());
    }

    public Class<? extends Filter> getFilterClass() {
        return BasicHTTPAuthenticationFilter.class;
    }

    public Map<String, String> getInitParameters() {
        return null;
    }

    public String getPath() {
        return "/*";
    }

    public EnumSet<DispatcherType> getDispatcherType() {
        return null;
    }

    public BasicAuthDBConfig getDbConfig() {
        return this.dbConfig;
    }

    public class BasicHTTPAuthenticationFilter
    implements Filter {
        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            HttpServletResponse httpResp = (HttpServletResponse)servletResponse;
            String encodedUserSecret = BasicAuthUtils.getEncodedUserSecretFromHttpReq((HttpServletRequest)servletRequest);
            if (encodedUserSecret == null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            String decodedUserSecret = BasicAuthUtils.decodeUserSecret(encodedUserSecret);
            if (decodedUserSecret == null) {
                httpResp.sendError(401);
                return;
            }
            String[] splits = decodedUserSecret.split(":");
            if (splits.length != 2) {
                httpResp.sendError(401);
                return;
            }
            String user = splits[0];
            char[] password = splits[1].toCharArray();
            try {
                AuthenticationResult authenticationResult = BasicHTTPAuthenticator.this.credentialsValidator.validateCredentials(BasicHTTPAuthenticator.this.name, BasicHTTPAuthenticator.this.authorizerName, user, password);
                if (authenticationResult != null) {
                    servletRequest.setAttribute("Druid-Authentication-Result", (Object)authenticationResult);
                    filterChain.doFilter(servletRequest, servletResponse);
                } else if (BasicHTTPAuthenticator.this.skipOnFailure) {
                    LOG.info("Skipping failed authenticator %s ", new Object[]{BasicHTTPAuthenticator.this.name});
                    filterChain.doFilter(servletRequest, servletResponse);
                } else {
                    httpResp.sendError(401);
                }
            }
            catch (BasicSecurityAuthenticationException ex) {
                LOG.info("Exception authenticating user %s - %s", new Object[]{user, ex.getMessage()});
                httpResp.sendError(401, "User authentication failed.");
            }
        }

        public void destroy() {
        }
    }
}

