/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.basic.BasicSecurityDBResourceException;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorUser;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerGroupMapping;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRole;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerUser;
import org.apache.druid.security.basic.authorization.entity.GroupMappingAndRoleMap;
import org.apache.druid.security.basic.authorization.entity.UserAndRoleMap;

public class BasicAuthUtils {
    private static final Logger log = new Logger(BasicAuthUtils.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    public static final String ADMIN_NAME = "admin";
    public static final String ADMIN_GROUP_MAPPING_NAME = "adminGroupMapping";
    public static final String INTERNAL_USER_NAME = "druid_system";
    public static final String SEARCH_RESULT_CONTEXT_KEY = "searchResult";
    public static final int SALT_LENGTH = 32;
    public static final int DEFAULT_KEY_ITERATIONS = 10000;
    public static final int DEFAULT_CREDENTIAL_VERIFY_DURATION_SECONDS = 600;
    public static final int DEFAULT_CREDENTIAL_MAX_DURATION_SECONDS = 3600;
    public static final int DEFAULT_CREDENTIAL_CACHE_SIZE = 100;
    public static final int KEY_LENGTH = 512;
    public static final String ALGORITHM = "PBKDF2WithHmacSHA512";
    public static final int MAX_INIT_RETRIES = 2;
    public static final Predicate<Throwable> SHOULD_RETRY_INIT = throwable -> throwable instanceof BasicSecurityDBResourceException;
    public static final TypeReference<Map<String, BasicAuthenticatorUser>> AUTHENTICATOR_USER_MAP_TYPE_REFERENCE = new TypeReference<Map<String, BasicAuthenticatorUser>>(){};
    public static final TypeReference<Map<String, BasicAuthorizerUser>> AUTHORIZER_USER_MAP_TYPE_REFERENCE = new TypeReference<Map<String, BasicAuthorizerUser>>(){};
    public static final TypeReference<Map<String, BasicAuthorizerGroupMapping>> AUTHORIZER_GROUP_MAPPING_MAP_TYPE_REFERENCE = new TypeReference<Map<String, BasicAuthorizerGroupMapping>>(){};
    public static final TypeReference<Map<String, BasicAuthorizerRole>> AUTHORIZER_ROLE_MAP_TYPE_REFERENCE = new TypeReference<Map<String, BasicAuthorizerRole>>(){};
    public static final TypeReference<UserAndRoleMap> AUTHORIZER_USER_AND_ROLE_MAP_TYPE_REFERENCE = new TypeReference<UserAndRoleMap>(){};
    public static final TypeReference<GroupMappingAndRoleMap> AUTHORIZER_GROUP_MAPPING_AND_ROLE_MAP_TYPE_REFERENCE = new TypeReference<GroupMappingAndRoleMap>(){};

    public static byte[] hashPassword(char[] password, byte[] salt, int iterations) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            SecretKey key = keyFactory.generateSecret(new PBEKeySpec(password, salt, iterations, 512));
            return key.getEncoded();
        }
        catch (InvalidKeySpecException ikse) {
            log.error("Invalid keyspec", new Object[0]);
            throw new RuntimeException("Invalid keyspec", ikse);
        }
        catch (NoSuchAlgorithmException nsae) {
            log.error("%s not supported on this system.", new Object[]{ALGORITHM});
            throw new RE((Throwable)nsae, "%s not supported on this system.", new Object[]{ALGORITHM});
        }
    }

    public static byte[] generateSalt() {
        byte[] salt = new byte[32];
        SECURE_RANDOM.nextBytes(salt);
        return salt;
    }

    @Nullable
    public static String getEncodedUserSecretFromHttpReq(HttpServletRequest httpReq) {
        String authHeader = httpReq.getHeader("Authorization");
        if (authHeader == null) {
            return null;
        }
        if (authHeader.length() < 7) {
            return null;
        }
        if (!"Basic ".equals(authHeader.substring(0, 6))) {
            return null;
        }
        return authHeader.substring(6);
    }

    @Nullable
    public static String decodeUserSecret(String encodedUserSecret) {
        try {
            return StringUtils.fromUtf8((byte[])StringUtils.decodeBase64String((String)encodedUserSecret));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public static Map<String, BasicAuthenticatorUser> deserializeAuthenticatorUserMap(ObjectMapper objectMapper, byte[] userMapBytes) {
        Map<String, BasicAuthenticatorUser> userMap;
        if (userMapBytes == null) {
            userMap = new HashMap<String, BasicAuthenticatorUser>();
        } else {
            try {
                userMap = (Map)objectMapper.readValue(userMapBytes, AUTHENTICATOR_USER_MAP_TYPE_REFERENCE);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Couldn't deserialize authenticator userMap!", ioe);
            }
        }
        return userMap;
    }

    public static byte[] serializeAuthenticatorUserMap(ObjectMapper objectMapper, Map<String, BasicAuthenticatorUser> userMap) {
        try {
            return objectMapper.writeValueAsBytes(userMap);
        }
        catch (IOException ioe) {
            throw new ISE((Throwable)ioe, "Couldn't serialize authenticator userMap!", new Object[0]);
        }
    }

    public static Map<String, BasicAuthorizerUser> deserializeAuthorizerUserMap(ObjectMapper objectMapper, byte[] userMapBytes) {
        Map<String, BasicAuthorizerUser> userMap;
        if (userMapBytes == null) {
            userMap = new HashMap<String, BasicAuthorizerUser>();
        } else {
            try {
                userMap = (Map)objectMapper.readValue(userMapBytes, AUTHORIZER_USER_MAP_TYPE_REFERENCE);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Couldn't deserialize authorizer userMap!", ioe);
            }
        }
        return userMap;
    }

    public static byte[] serializeAuthorizerUserMap(ObjectMapper objectMapper, Map<String, BasicAuthorizerUser> userMap) {
        try {
            return objectMapper.writeValueAsBytes(userMap);
        }
        catch (IOException ioe) {
            throw new ISE((Throwable)ioe, "Couldn't serialize authorizer userMap!", new Object[0]);
        }
    }

    public static Map<String, BasicAuthorizerGroupMapping> deserializeAuthorizerGroupMappingMap(ObjectMapper objectMapper, byte[] groupMappingMapBytes) {
        Map<String, BasicAuthorizerGroupMapping> groupMappingMap;
        if (groupMappingMapBytes == null) {
            groupMappingMap = new HashMap<String, BasicAuthorizerGroupMapping>();
        } else {
            try {
                groupMappingMap = (Map)objectMapper.readValue(groupMappingMapBytes, AUTHORIZER_GROUP_MAPPING_MAP_TYPE_REFERENCE);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Couldn't deserialize authorizer groupMappingMap!", ioe);
            }
        }
        return groupMappingMap;
    }

    public static byte[] serializeAuthorizerGroupMappingMap(ObjectMapper objectMapper, Map<String, BasicAuthorizerGroupMapping> groupMappingMap) {
        try {
            return objectMapper.writeValueAsBytes(groupMappingMap);
        }
        catch (IOException ioe) {
            throw new ISE((Throwable)ioe, "Couldn't serialize authorizer groupMappingMap!", new Object[0]);
        }
    }

    public static Map<String, BasicAuthorizerRole> deserializeAuthorizerRoleMap(ObjectMapper objectMapper, byte[] roleMapBytes) {
        Map<String, BasicAuthorizerRole> roleMap;
        if (roleMapBytes == null) {
            roleMap = new HashMap<String, BasicAuthorizerRole>();
        } else {
            try {
                roleMap = (Map)objectMapper.readValue(roleMapBytes, AUTHORIZER_ROLE_MAP_TYPE_REFERENCE);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Couldn't deserialize authorizer roleMap!", ioe);
            }
        }
        return roleMap;
    }

    public static byte[] serializeAuthorizerRoleMap(ObjectMapper objectMapper, Map<String, BasicAuthorizerRole> roleMap) {
        try {
            return objectMapper.writeValueAsBytes(roleMap);
        }
        catch (IOException ioe) {
            throw new ISE((Throwable)ioe, "Couldn't serialize authorizer roleMap!", new Object[0]);
        }
    }

    public static void maybeInitialize(RetryUtils.Task<?> task) {
        try {
            RetryUtils.retry(task, SHOULD_RETRY_INIT, (int)2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

