/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.orc;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.orc.OrcStructFlattenerMaker;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcMapredRecordReader;
import org.apache.orc.mapred.OrcStruct;

public class OrcReader
extends IntermediateRowParsingReader<OrcStruct> {
    private final Configuration conf;
    private final InputRowSchema inputRowSchema;
    private final InputEntity source;
    private final File temporaryDirectory;
    private final ObjectFlattener<OrcStruct> orcStructFlattener;

    OrcReader(Configuration conf, InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory, @Nullable JSONPathSpec flattenSpec, boolean binaryAsString) {
        this.conf = conf;
        this.inputRowSchema = inputRowSchema;
        this.source = source;
        this.temporaryDirectory = temporaryDirectory;
        this.orcStructFlattener = ObjectFlatteners.create((JSONPathSpec)flattenSpec, (ObjectFlatteners.FlattenerMaker)new OrcStructFlattenerMaker(binaryAsString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableIterator<OrcStruct> intermediateRowIterator() throws IOException {
        Reader reader;
        final Closer closer = Closer.create();
        byte[] buffer = new byte[4096];
        InputEntity.CleanableFile file = (InputEntity.CleanableFile)closer.register((Closeable)this.source.fetch(this.temporaryDirectory, buffer));
        Path path = new Path(file.file().toURI());
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            reader = (Reader)closer.register((Closeable)OrcFile.createReader((Path)path, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf)));
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        TypeDescription schema = reader.getSchema();
        RecordReader batchReader = reader.rows(reader.options());
        final OrcMapredRecordReader recordReader = new OrcMapredRecordReader(batchReader, schema);
        closer.register(() -> ((OrcMapredRecordReader)recordReader).close());
        return new CloseableIterator<OrcStruct>(){
            final NullWritable key;
            OrcStruct value;
            {
                this.key = recordReader.createKey();
                this.value = null;
            }

            public boolean hasNext() {
                if (this.value == null) {
                    try {
                        this.value = (OrcStruct)recordReader.createValue();
                        if (!recordReader.next(this.key, (WritableComparable)this.value)) {
                            this.value = null;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.value != null;
            }

            public OrcStruct next() {
                if (this.value == null) {
                    throw new NoSuchElementException();
                }
                OrcStruct currentValue = this.value;
                this.value = null;
                return currentValue;
            }

            public void close() throws IOException {
                closer.close();
            }
        };
    }

    protected InputEntity source() {
        return this.source;
    }

    protected List<InputRow> parseInputRows(OrcStruct intermediateRow) throws ParseException {
        return Collections.singletonList(MapInputRowParser.parse((InputRowSchema)this.inputRowSchema, (Map)this.orcStructFlattener.flatten((Object)intermediateRow)));
    }

    protected List<Map<String, Object>> toMap(OrcStruct intermediateRow) {
        return Collections.singletonList(this.orcStructFlattener.toMap((Object)intermediateRow));
    }
}

