/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.orc;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.NestedInputFormat;
import org.apache.druid.data.input.orc.OrcReader;
import org.apache.druid.data.input.orc.guice.Orc;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class OrcInputFormat
extends NestedInputFormat {
    private final boolean binaryAsString;
    private final Configuration conf;

    @JsonCreator
    public OrcInputFormat(@JsonProperty(value="flattenSpec") @Nullable JSONPathSpec flattenSpec, @JsonProperty(value="binaryAsString") @Nullable Boolean binaryAsString, @JacksonInject @Orc Configuration conf) {
        super(flattenSpec);
        this.binaryAsString = binaryAsString != null && binaryAsString != false;
        this.conf = conf;
    }

    private void initialize(Configuration conf) {
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            FileSystem.get((Configuration)conf);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
    }

    public boolean isSplittable() {
        return false;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean getBinaryAsString() {
        return this.binaryAsString;
    }

    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        this.initialize(this.conf);
        return new OrcReader(this.conf, inputRowSchema, source, temporaryDirectory, this.getFlattenSpec(), this.binaryAsString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrcInputFormat that = (OrcInputFormat)((Object)o);
        return this.binaryAsString == that.binaryAsString && Objects.equals(this.conf, that.conf);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.binaryAsString, this.conf);
    }
}

