/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.druid.data.input.avro.AvroBytesDecoder;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.utils.DynamicConfigProviderUtils;

public class SchemaRegistryBasedAvroBytesDecoder
implements AvroBytesDecoder {
    private final SchemaRegistryClient registry;
    private final String url;
    private final int capacity;
    private final List<String> urls;
    private final Map<String, Object> config;
    private final Map<String, Object> headers;
    private final ObjectMapper jsonMapper;
    public static final String DRUID_DYNAMIC_CONFIG_PROVIDER_KEY = "druid.dynamic.config.provider";

    @JsonCreator
    public SchemaRegistryBasedAvroBytesDecoder(@JsonProperty(value="url") @Deprecated String url, @JsonProperty(value="capacity") Integer capacity, @JsonProperty(value="urls") @Nullable List<String> urls, @JsonProperty(value="config") @Nullable Map<String, Object> config, @JsonProperty(value="headers") @Nullable Map<String, Object> headers, @JacksonInject @Json ObjectMapper jsonMapper) {
        this.url = url;
        this.capacity = capacity == null ? Integer.MAX_VALUE : capacity;
        this.urls = urls;
        this.config = config;
        this.headers = headers;
        this.jsonMapper = jsonMapper;
        this.registry = url != null && !url.isEmpty() ? new CachedSchemaRegistryClient(this.url, this.capacity, DynamicConfigProviderUtils.extraConfigAndSetObjectMap(config, (String)DRUID_DYNAMIC_CONFIG_PROVIDER_KEY, (ObjectMapper)this.jsonMapper), DynamicConfigProviderUtils.extraConfigAndSetStringMap(headers, (String)DRUID_DYNAMIC_CONFIG_PROVIDER_KEY, (ObjectMapper)this.jsonMapper)) : new CachedSchemaRegistryClient(this.urls, this.capacity, DynamicConfigProviderUtils.extraConfigAndSetObjectMap(config, (String)DRUID_DYNAMIC_CONFIG_PROVIDER_KEY, (ObjectMapper)this.jsonMapper), DynamicConfigProviderUtils.extraConfigAndSetStringMap(headers, (String)DRUID_DYNAMIC_CONFIG_PROVIDER_KEY, (ObjectMapper)this.jsonMapper));
    }

    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    @JsonProperty
    public int getCapacity() {
        return this.capacity;
    }

    @JsonProperty
    public List<String> getUrls() {
        return this.urls;
    }

    @JsonProperty
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @JsonProperty
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @VisibleForTesting
    SchemaRegistryBasedAvroBytesDecoder(SchemaRegistryClient registry) {
        this.url = null;
        this.capacity = Integer.MAX_VALUE;
        this.urls = null;
        this.config = null;
        this.headers = null;
        this.registry = registry;
        this.jsonMapper = new ObjectMapper();
    }

    @Override
    public GenericRecord parse(ByteBuffer bytes) {
        Schema schema;
        int length = bytes.limit() - 1 - 4;
        if (length < 0) {
            throw new ParseException(null, "Failed to decode avro message, not enough bytes to decode (%s)", new Object[]{bytes.limit()});
        }
        bytes.get();
        int id = bytes.getInt();
        int offset = bytes.position() + bytes.arrayOffset();
        try {
            ParsedSchema parsedSchema = this.registry.getSchemaById(id);
            schema = parsedSchema instanceof AvroSchema ? ((AvroSchema)parsedSchema).rawSchema() : null;
        }
        catch (RestClientException | IOException ex) {
            throw new ParseException(null, "Failed to get Avro schema: %s", new Object[]{id});
        }
        if (schema == null) {
            throw new ParseException(null, "Failed to find Avro schema: %s", new Object[]{id});
        }
        GenericDatumReader reader = new GenericDatumReader(schema);
        try {
            return (GenericRecord)reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(bytes.array(), offset, length, null));
        }
        catch (Exception e) {
            throw new ParseException(null, (Throwable)e, "Fail to decode Avro message for schema: %s!", new Object[]{id});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRegistryBasedAvroBytesDecoder that = (SchemaRegistryBasedAvroBytesDecoder)o;
        return this.capacity == that.capacity && Objects.equals(this.url, that.url) && Objects.equals(this.urls, that.urls) && Objects.equals(this.config, that.config) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.registry, this.url, this.capacity, this.urls, this.config, this.headers, this.jsonMapper);
    }
}

