/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.EOFException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.druid.data.input.avro.AvroBytesDecoder;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.ParseException;

public class InlineSchemasAvroBytesDecoder
implements AvroBytesDecoder {
    private static final Logger LOGGER = new Logger(InlineSchemasAvroBytesDecoder.class);
    private static final byte V1 = 1;
    private final Map<Integer, Schema> schemaObjs;
    private final Map<String, Map<String, Object>> schemas;

    @JsonCreator
    public InlineSchemasAvroBytesDecoder(@JacksonInject @Json ObjectMapper mapper, @JsonProperty(value="schemas") Map<String, Map<String, Object>> schemas) throws Exception {
        Preconditions.checkArgument((schemas != null && schemas.size() > 0 ? 1 : 0) != 0, (Object)"at least one schema must be provided in schemas attribute");
        this.schemas = schemas;
        this.schemaObjs = Maps.newHashMapWithExpectedSize((int)schemas.size());
        for (Map.Entry<String, Map<String, Object>> e : schemas.entrySet()) {
            int id = Integer.parseInt(e.getKey());
            Map<String, Object> schema = e.getValue();
            String schemaStr = mapper.writeValueAsString(schema);
            LOGGER.debug("Schema string [%s] = [%s]", new Object[]{id, schemaStr});
            this.schemaObjs.put(id, new Schema.Parser().parse(schemaStr));
        }
    }

    @VisibleForTesting
    public InlineSchemasAvroBytesDecoder(Map<Integer, Schema> schemaObjs) {
        this.schemaObjs = schemaObjs;
        this.schemas = null;
    }

    @JsonProperty
    public Map<String, Map<String, Object>> getSchemas() {
        return this.schemas;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GenericRecord parse(ByteBuffer bytes) {
        if (bytes.remaining() < 5) {
            throw new ParseException(null, "record must have at least 5 bytes carrying version and schemaId", new Object[0]);
        }
        byte version = bytes.get();
        if (version != 1) {
            throw new ParseException(null, "found record of arbitrary version [%s]", new Object[]{version});
        }
        int schemaId = bytes.getInt();
        Schema schemaObj = this.schemaObjs.get(schemaId);
        if (schemaObj == null) {
            throw new ParseException(null, "Failed to find schema for id [%s]", new Object[]{schemaId});
        }
        GenericDatumReader reader = new GenericDatumReader(schemaObj);
        try (ByteBufferInputStream inputStream = new ByteBufferInputStream(Collections.singletonList(bytes));){
            GenericRecord genericRecord = (GenericRecord)reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder((InputStream)inputStream, null));
            return genericRecord;
        }
        catch (EOFException eof) {
            throw new ParseException(null, (Throwable)eof, "Avro's unnecessary EOFException, detail: [%s]", new Object[]{"https://issues.apache.org/jira/browse/AVRO-813"});
        }
        catch (Exception e) {
            throw new ParseException(null, (Throwable)e, "Fail to decode avro message with schemaId [%s].", new Object[]{schemaId});
        }
    }
}

