/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.avro.AvroFlattenerMaker;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.druid.java.util.common.parsers.ParseException;

public class AvroOCFReader
extends IntermediateRowParsingReader<GenericRecord> {
    private final InputRowSchema inputRowSchema;
    private final InputEntity source;
    private final File temporaryDirectory;
    private final ObjectFlattener<GenericRecord> recordFlattener;
    private Schema readerSchema;

    AvroOCFReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory, @Nullable Schema readerSchema, @Nullable JSONPathSpec flattenSpec, boolean binaryAsString, boolean extractUnionsByType) {
        this.inputRowSchema = inputRowSchema;
        this.source = source;
        this.temporaryDirectory = temporaryDirectory;
        this.readerSchema = readerSchema;
        this.recordFlattener = ObjectFlatteners.create((JSONPathSpec)flattenSpec, (ObjectFlatteners.FlattenerMaker)new AvroFlattenerMaker(false, binaryAsString, extractUnionsByType));
    }

    protected CloseableIterator<GenericRecord> intermediateRowIterator() throws IOException {
        final Closer closer = Closer.create();
        byte[] buffer = new byte[4096];
        try {
            InputEntity.CleanableFile file = (InputEntity.CleanableFile)closer.register((Closeable)this.source.fetch(this.temporaryDirectory, buffer));
            GenericDatumReader datumReader = new GenericDatumReader();
            final DataFileReader dataFileReader = new DataFileReader(file.file(), (DatumReader)datumReader);
            Schema writerSchema = dataFileReader.getSchema();
            if (this.readerSchema == null) {
                this.readerSchema = writerSchema;
            }
            datumReader.setSchema(writerSchema);
            datumReader.setExpected(this.readerSchema);
            closer.register((Closeable)dataFileReader);
            return new CloseableIterator<GenericRecord>(){

                public boolean hasNext() {
                    return dataFileReader.hasNext();
                }

                public GenericRecord next() {
                    return (GenericRecord)dataFileReader.next();
                }

                public void close() throws IOException {
                    closer.close();
                }
            };
        }
        catch (Exception e) {
            closer.close();
            throw new RuntimeException(e);
        }
    }

    protected InputEntity source() {
        return this.source;
    }

    protected List<InputRow> parseInputRows(GenericRecord intermediateRow) throws ParseException {
        return Collections.singletonList(MapInputRowParser.parse((InputRowSchema)this.inputRowSchema, (Map)this.recordFlattener.flatten((Object)intermediateRow)));
    }

    protected List<Map<String, Object>> toMap(GenericRecord intermediateRow) {
        return Collections.singletonList(this.recordFlattener.toMap((Object)intermediateRow));
    }
}

