/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureCloudBlobIterable;
import org.apache.druid.storage.azure.AzureCloudBlobIterableFactory;
import org.apache.druid.storage.azure.AzureInputDataConfig;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.blob.CloudBlobHolder;

public class AzureUtils {
    @VisibleForTesting
    static final String AZURE_STORAGE_HOST_ADDRESS = "blob.core.windows.net";
    static final String AZURE_STORAGE_HADOOP_PROTOCOL = "wasbs";
    public static final Predicate<Throwable> AZURE_RETRY = e -> {
        if (e == null) {
            return false;
        }
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (t instanceof URISyntaxException) {
                return false;
            }
            if (t instanceof StorageException) {
                return true;
            }
            if (!(t instanceof IOException)) continue;
            return true;
        }
        return false;
    };

    public static String extractAzureKey(URI uri) {
        return StringUtils.maybeRemoveLeadingSlash((String)uri.getPath());
    }

    public static String maybeRemoveAzurePathPrefix(String blobPath) {
        boolean blobPathIsHadoop = blobPath.contains(AZURE_STORAGE_HOST_ADDRESS);
        if (blobPathIsHadoop) {
            return blobPath.substring(blobPath.indexOf(AZURE_STORAGE_HOST_ADDRESS) + AZURE_STORAGE_HOST_ADDRESS.length() + 1);
        }
        return blobPath;
    }

    public static void deleteObjectsInPath(AzureStorage storage, AzureInputDataConfig config, AzureAccountConfig accountConfig, AzureCloudBlobIterableFactory azureCloudBlobIterableFactory, String bucket, String prefix, Predicate<CloudBlobHolder> filter) throws Exception {
        AzureCloudBlobIterable azureCloudBlobIterable = azureCloudBlobIterableFactory.create((Iterable<URI>)ImmutableList.of((Object)new CloudObjectLocation(bucket, prefix).toUri("azure")), config.getMaxListingLength());
        for (CloudBlobHolder nextObject : azureCloudBlobIterable) {
            if (!filter.apply((Object)nextObject)) continue;
            AzureUtils.deleteBucketKeys(storage, accountConfig.getMaxTries(), nextObject.getContainerName(), nextObject.getName());
        }
    }

    private static void deleteBucketKeys(AzureStorage storage, int maxTries, String bucket, String prefix) throws Exception {
        AzureUtils.retryAzureOperation(() -> {
            storage.emptyCloudBlobDirectory(bucket, prefix);
            return null;
        }, maxTries);
    }

    static <T> T retryAzureOperation(RetryUtils.Task<T> f, int maxTries) throws Exception {
        return (T)RetryUtils.retry(f, AZURE_RETRY, (int)maxTries);
    }
}

