/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.List;
import org.apache.druid.data.input.azure.AzureEntityFactory;
import org.apache.druid.data.input.azure.AzureInputSource;
import org.apache.druid.firehose.azure.StaticAzureBlobStoreFirehoseFactory;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureByteSourceFactory;
import org.apache.druid.storage.azure.AzureCloudBlobHolderToCloudObjectLocationConverter;
import org.apache.druid.storage.azure.AzureCloudBlobIterableFactory;
import org.apache.druid.storage.azure.AzureCloudBlobIteratorFactory;
import org.apache.druid.storage.azure.AzureDataSegmentConfig;
import org.apache.druid.storage.azure.AzureDataSegmentKiller;
import org.apache.druid.storage.azure.AzureDataSegmentPusher;
import org.apache.druid.storage.azure.AzureInputDataConfig;
import org.apache.druid.storage.azure.AzureLoadSpec;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureTaskLogs;
import org.apache.druid.storage.azure.AzureTaskLogsConfig;
import org.apache.druid.storage.azure.blob.ListBlobItemHolderFactory;

public class AzureStorageDruidModule
implements DruidModule {
    static final String SCHEME = "azure";
    public static final String STORAGE_CONNECTION_STRING_WITH_KEY = "DefaultEndpointsProtocol=%s;AccountName=%s;AccountKey=%s";
    public static final String STORAGE_CONNECTION_STRING_WITH_TOKEN = "DefaultEndpointsProtocol=%s;AccountName=%s;SharedAccessSignature=%s";
    public static final String INDEX_ZIP_FILE_NAME = "index.zip";

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new Module(){

            public String getModuleName() {
                return "DruidAzure-" + System.identityHashCode((Object)this);
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new Class[]{AzureLoadSpec.class});
            }
        }, (Object)new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(StaticAzureBlobStoreFirehoseFactory.class, "static-azure-blobstore"), new NamedType(AzureInputSource.class, SCHEME)}));
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.azure", AzureInputDataConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.azure", AzureDataSegmentConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.azure", AzureAccountConfig.class);
        Binders.dataSegmentPusherBinder((Binder)binder).addBinding((Object)SCHEME).to(AzureDataSegmentPusher.class).in(LazySingleton.class);
        Binders.dataSegmentKillerBinder((Binder)binder).addBinding((Object)SCHEME).to(AzureDataSegmentKiller.class).in(LazySingleton.class);
        Binders.taskLogsBinder((Binder)binder).addBinding((Object)SCHEME).to(AzureTaskLogs.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.logs", AzureTaskLogsConfig.class);
        binder.bind(AzureTaskLogs.class).in(LazySingleton.class);
        binder.bind(AzureCloudBlobHolderToCloudObjectLocationConverter.class).in(LazySingleton.class);
        binder.install(new FactoryModuleBuilder().build(AzureByteSourceFactory.class));
        binder.install(new FactoryModuleBuilder().build(AzureEntityFactory.class));
        binder.install(new FactoryModuleBuilder().build(AzureCloudBlobIteratorFactory.class));
        binder.install(new FactoryModuleBuilder().build(AzureCloudBlobIterableFactory.class));
        binder.install(new FactoryModuleBuilder().build(ListBlobItemHolderFactory.class));
    }

    @Provides
    @LazySingleton
    public Supplier<CloudBlobClient> getCloudBlobClient(AzureAccountConfig config) {
        if (config.getKey() != null && config.getSharedAccessStorageToken() != null || config.getKey() == null && config.getSharedAccessStorageToken() == null) {
            throw new ISE("Either set 'key' or 'sharedAccessStorageToken' in the azure config but not both. Please refer to azure documentation.", new Object[0]);
        }
        return Suppliers.memoize(() -> {
            try {
                if (config.getKey() != null) {
                    CloudStorageAccount account = CloudStorageAccount.parse((String)StringUtils.format((String)STORAGE_CONNECTION_STRING_WITH_KEY, (Object[])new Object[]{config.getProtocol(), config.getAccount(), config.getKey()}));
                    return account.createCloudBlobClient();
                }
                if (config.getSharedAccessStorageToken() != null) {
                    CloudStorageAccount account = CloudStorageAccount.parse((String)StringUtils.format((String)STORAGE_CONNECTION_STRING_WITH_TOKEN, (Object[])new Object[]{config.getProtocol(), config.getAccount(), config.getSharedAccessStorageToken()}));
                    return account.createCloudBlobClient();
                }
                throw new ISE("None of 'key' or 'sharedAccessStorageToken' is set in the azure config. Please refer to azure extension documentation.", new Object[0]);
            }
            catch (URISyntaxException | InvalidKeyException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Provides
    @LazySingleton
    public AzureStorage getAzureStorageContainer(Supplier<CloudBlobClient> cloudBlobClient) {
        return new AzureStorage(cloudBlobClient);
    }
}

