/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.microsoft.azure.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureDataSegmentConfig;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CompressionUtils;
import org.joda.time.format.ISODateTimeFormat;

public class AzureDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(AzureDataSegmentPusher.class);
    static final List<String> ALLOWED_PROPERTY_PREFIXES_FOR_HADOOP = ImmutableList.of((Object)"druid.azure");
    private final AzureStorage azureStorage;
    private final AzureAccountConfig accountConfig;
    private final AzureDataSegmentConfig segmentConfig;

    @Inject
    public AzureDataSegmentPusher(AzureStorage azureStorage, AzureAccountConfig accountConfig, AzureDataSegmentConfig segmentConfig) {
        this.azureStorage = azureStorage;
        this.accountConfig = accountConfig;
        this.segmentConfig = segmentConfig;
    }

    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    public String getPathForHadoop() {
        String prefix = this.segmentConfig.getPrefix();
        boolean prefixIsNullOrEmpty = org.apache.commons.lang.StringUtils.isEmpty((String)prefix);
        String hadoopPath = StringUtils.format((String)"%s://%s@%s.%s/%s", (Object[])new Object[]{"wasbs", this.segmentConfig.getContainer(), this.accountConfig.getAccount(), "blob.core.windows.net", prefixIsNullOrEmpty ? "" : StringUtils.maybeRemoveTrailingSlash((String)prefix) + '/'});
        log.info("Using Azure blob storage Hadoop path: %s", new Object[]{hadoopPath});
        return hadoopPath;
    }

    public String getStorageDir(DataSegment dataSegment, boolean useUniquePath) {
        String seg = JOINER.join((Object)dataSegment.getDataSource(), (Object)StringUtils.format((String)"%s_%s", (Object[])new Object[]{dataSegment.getInterval().getStart().toString(ISODateTimeFormat.basicDateTime()), dataSegment.getInterval().getEnd().toString(ISODateTimeFormat.basicDateTime())}), new Object[]{dataSegment.getVersion().replace(':', '_'), dataSegment.getShardSpec().getPartitionNum(), useUniquePath ? DataSegmentPusher.generateUniquePath() : null});
        log.info("DataSegment Suffix: [%s]", new Object[]{seg});
        return seg;
    }

    public List<String> getAllowedPropertyPrefixesForHadoop() {
        return ALLOWED_PROPERTY_PREFIXES_FOR_HADOOP;
    }

    public DataSegment push(File indexFilesDir, DataSegment segment, boolean useUniquePath) throws IOException {
        log.info("Uploading [%s] to Azure.", new Object[]{indexFilesDir});
        String azurePathSuffix = this.getAzurePath(segment, useUniquePath);
        return this.pushToPath(indexFilesDir, segment, azurePathSuffix);
    }

    public DataSegment pushToPath(File indexFilesDir, DataSegment segment, String storageDirSuffix) throws IOException {
        DataSegment dataSegment;
        block5: {
            String prefix = this.segmentConfig.getPrefix();
            boolean prefixIsNullOrEmpty = org.apache.commons.lang.StringUtils.isEmpty((String)prefix);
            String azurePath = JOINER.join((Object)(prefixIsNullOrEmpty ? null : StringUtils.maybeRemoveTrailingSlash((String)prefix)), (Object)storageDirSuffix, new Object[0]);
            int binaryVersion = SegmentUtils.getVersionFromDir((File)indexFilesDir);
            File zipOutFile = null;
            try {
                File outFile = zipOutFile = File.createTempFile("index", ".zip");
                long size = CompressionUtils.zip((File)indexFilesDir, (File)zipOutFile);
                dataSegment = (DataSegment)AzureUtils.retryAzureOperation(() -> this.uploadDataSegment(segment, binaryVersion, size, outFile, azurePath), this.accountConfig.getMaxTries());
                if (zipOutFile == null) break block5;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (zipOutFile != null) {
                        log.info("Deleting zipped index File[%s]", new Object[]{zipOutFile});
                        zipOutFile.delete();
                    }
                    throw throwable;
                }
            }
            log.info("Deleting zipped index File[%s]", new Object[]{zipOutFile});
            zipOutFile.delete();
        }
        return dataSegment;
    }

    public Map<String, Object> makeLoadSpec(URI uri) {
        return this.makeLoadSpec(uri.toString());
    }

    @VisibleForTesting
    String getAzurePath(DataSegment segment, boolean useUniquePath) {
        String storageDir = this.getStorageDir(segment, useUniquePath);
        return StringUtils.format((String)"%s/%s", (Object[])new Object[]{storageDir, "index.zip"});
    }

    @VisibleForTesting
    DataSegment uploadDataSegment(DataSegment segment, int binaryVersion, long size, File compressedSegmentData, String azurePath) throws StorageException, IOException, URISyntaxException {
        this.azureStorage.uploadBlob(compressedSegmentData, this.segmentConfig.getContainer(), azurePath);
        DataSegment outSegment = segment.withSize(size).withLoadSpec(this.makeLoadSpec(azurePath)).withBinaryVersion(binaryVersion);
        log.debug("Deleting file [%s]", new Object[]{compressedSegmentData});
        compressedSegmentData.delete();
        return outSegment;
    }

    private Map<String, Object> makeLoadSpec(String prefix) {
        return ImmutableMap.of((Object)"type", (Object)"azure", (Object)"containerName", (Object)this.segmentConfig.getContainer(), (Object)"blobPath", (Object)prefix);
    }
}

