/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureCloudBlobIterableFactory;
import org.apache.druid.storage.azure.AzureDataSegmentConfig;
import org.apache.druid.storage.azure.AzureInputDataConfig;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureUtils;
import org.apache.druid.storage.azure.blob.CloudBlobHolder;
import org.apache.druid.timeline.DataSegment;

public class AzureDataSegmentKiller
implements DataSegmentKiller {
    private static final Logger log = new Logger(AzureDataSegmentKiller.class);
    private final AzureDataSegmentConfig segmentConfig;
    private final AzureInputDataConfig inputDataConfig;
    private final AzureAccountConfig accountConfig;
    private final AzureStorage azureStorage;
    private final AzureCloudBlobIterableFactory azureCloudBlobIterableFactory;

    @Inject
    public AzureDataSegmentKiller(AzureDataSegmentConfig segmentConfig, AzureInputDataConfig inputDataConfig, AzureAccountConfig accountConfig, AzureStorage azureStorage, AzureCloudBlobIterableFactory azureCloudBlobIterableFactory) {
        this.segmentConfig = segmentConfig;
        this.inputDataConfig = inputDataConfig;
        this.accountConfig = accountConfig;
        this.azureStorage = azureStorage;
        this.azureCloudBlobIterableFactory = azureCloudBlobIterableFactory;
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        log.info("Killing segment [%s]", new Object[]{segment});
        Map loadSpec = segment.getLoadSpec();
        String containerName = MapUtils.getString((Map)loadSpec, (String)"containerName");
        String blobPath = MapUtils.getString((Map)loadSpec, (String)"blobPath");
        String dirPath = Paths.get(blobPath, new String[0]).getParent().toString();
        try {
            this.azureStorage.emptyCloudBlobDirectory(containerName, dirPath);
        }
        catch (StorageException e) {
            String extendedInfo = e.getExtendedErrorInformation() == null ? null : e.getExtendedErrorInformation().getErrorMessage();
            throw new SegmentLoadingException((Throwable)e, "Couldn't kill segment[%s]: [%s]", new Object[]{segment.getId(), extendedInfo});
        }
        catch (URISyntaxException e) {
            throw new SegmentLoadingException((Throwable)e, "Couldn't kill segment[%s]: [%s]", new Object[]{segment.getId(), e.getReason()});
        }
    }

    public void killAll() throws IOException {
        if (this.segmentConfig.getContainer() == null || this.segmentConfig.getPrefix() == null) {
            throw new ISE("Cannot delete all segment files since Azure Deep Storage since druid.azure.container and druid.azure.prefix are not both set.", new Object[0]);
        }
        log.info("Deleting all segment files from Azure storage location [bucket: '%s' prefix: '%s']", new Object[]{this.segmentConfig.getContainer(), this.segmentConfig.getPrefix()});
        try {
            AzureUtils.deleteObjectsInPath(this.azureStorage, this.inputDataConfig, this.accountConfig, this.azureCloudBlobIterableFactory, this.segmentConfig.getContainer(), this.segmentConfig.getPrefix(), (Predicate<CloudBlobHolder>)Predicates.alwaysTrue());
        }
        catch (Exception e) {
            log.error("Error occurred while deleting segment files from Azure. Error: %s", new Object[]{e.getMessage()});
            throw new IOException(e);
        }
    }
}

