/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.http;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.druid.catalog.CatalogException;
import org.apache.druid.catalog.http.TableEditRequest;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.catalog.model.table.AbstractDatasourceDefn;
import org.apache.druid.catalog.storage.CatalogStorage;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.utils.CollectionUtils;

public class TableEditor {
    private final CatalogStorage catalog;
    private final TableId id;
    private final TableEditRequest editRequest;

    public TableEditor(CatalogStorage catalog, TableId id, TableEditRequest editRequest) {
        this.catalog = catalog;
        this.id = id;
        this.editRequest = editRequest;
    }

    public long go() throws CatalogException {
        if (this.editRequest instanceof TableEditRequest.HideColumns) {
            return this.hideColumns(((TableEditRequest.HideColumns)this.editRequest).columns);
        }
        if (this.editRequest instanceof TableEditRequest.UnhideColumns) {
            return this.unHideColumns(((TableEditRequest.UnhideColumns)this.editRequest).columns);
        }
        if (this.editRequest instanceof TableEditRequest.DropColumns) {
            return this.dropColumns(((TableEditRequest.DropColumns)this.editRequest).columns);
        }
        if (this.editRequest instanceof TableEditRequest.UpdateProperties) {
            return this.updateProperties(((TableEditRequest.UpdateProperties)this.editRequest).properties);
        }
        if (this.editRequest instanceof TableEditRequest.UpdateColumns) {
            return this.updateColumns(((TableEditRequest.UpdateColumns)this.editRequest).columns);
        }
        if (this.editRequest instanceof TableEditRequest.MoveColumn) {
            return this.moveColumn((TableEditRequest.MoveColumn)this.editRequest);
        }
        throw CatalogException.badRequest("Unknown edit request: %s", this.editRequest.getClass().getSimpleName());
    }

    private long hideColumns(List<String> columns) throws CatalogException {
        if (CollectionUtils.isNullOrEmpty(columns)) {
            return 0L;
        }
        return this.catalog.tables().updateProperties(this.id, table -> this.applyHiddenColumns(table, columns));
    }

    private TableSpec applyHiddenColumns(TableMetadata table, List<String> columns) throws CatalogException {
        if (!AbstractDatasourceDefn.isDatasource((String)table.spec().type())) {
            throw CatalogException.badRequest("hideColumns is supported only for data source specs", new Object[0]);
        }
        TableSpec spec = table.spec();
        if (columns.isEmpty()) {
            return null;
        }
        Map props = spec.properties();
        List hiddenColumns = (List)props.get("hiddenColumns");
        if (hiddenColumns == null) {
            hiddenColumns = Collections.emptyList();
        }
        HashSet existing = new HashSet(hiddenColumns);
        ArrayList revised = new ArrayList(hiddenColumns);
        for (String col : columns) {
            if (existing.contains(col)) continue;
            revised.add(col);
            existing.add(col);
        }
        if (revised.size() == hiddenColumns.size()) {
            return null;
        }
        HashMap revisedProps = new HashMap(props);
        revisedProps.put("hiddenColumns", revised);
        return spec.withProperties(revisedProps);
    }

    private long unHideColumns(List<String> columns) throws CatalogException {
        if (CollectionUtils.isNullOrEmpty(columns)) {
            return 0L;
        }
        return this.catalog.tables().updateProperties(this.id, table -> this.applyUnhideColumns(table, columns));
    }

    private TableSpec applyUnhideColumns(TableMetadata table, List<String> columns) throws CatalogException {
        TableSpec existingSpec = table.spec();
        if (!AbstractDatasourceDefn.isDatasource((String)existingSpec.type())) {
            throw CatalogException.badRequest("hideColumns is supported only for data source specs", new Object[0]);
        }
        Map props = existingSpec.properties();
        List hiddenColumns = (List)props.get("hiddenColumns");
        if (hiddenColumns == null || columns.isEmpty()) {
            return null;
        }
        HashSet<String> removals = new HashSet<String>(columns);
        ArrayList<String> revisedHiddenCols = new ArrayList<String>();
        for (String col : hiddenColumns) {
            if (removals.contains(col)) continue;
            revisedHiddenCols.add(col);
        }
        if (revisedHiddenCols.size() == hiddenColumns.size() && !hiddenColumns.isEmpty()) {
            return null;
        }
        HashMap<String, ArrayList<String>> revisedProps = new HashMap<String, ArrayList<String>>(props);
        if (revisedHiddenCols.isEmpty()) {
            revisedProps.remove("hiddenColumns");
        } else {
            revisedProps.put("hiddenColumns", revisedHiddenCols);
        }
        return existingSpec.withProperties(revisedProps);
    }

    private long dropColumns(List<String> columnsToDrop) throws CatalogException {
        if (CollectionUtils.isNullOrEmpty(columnsToDrop)) {
            return 0L;
        }
        return this.catalog.tables().updateColumns(this.id, table -> this.applyDropColumns(table, columnsToDrop));
    }

    private TableSpec applyDropColumns(TableMetadata table, List<String> toDrop) {
        TableSpec existingSpec = table.spec();
        List existingColumns = existingSpec.columns();
        if (CollectionUtils.isNullOrEmpty((Collection)existingColumns)) {
            return null;
        }
        HashSet<String> drop = new HashSet<String>(toDrop);
        ArrayList<ColumnSpec> revised = new ArrayList<ColumnSpec>();
        for (ColumnSpec col : existingColumns) {
            if (drop.contains(col.name())) continue;
            revised.add(col);
        }
        if (revised.size() == existingColumns.size()) {
            return null;
        }
        return existingSpec.withColumns(revised);
    }

    private long updateProperties(Map<String, Object> updates) throws CatalogException {
        if (updates == null || updates.isEmpty()) {
            return 0L;
        }
        return this.catalog.tables().updateProperties(this.id, table -> this.applyUpdateProperties(table, updates));
    }

    private TableSpec applyUpdateProperties(TableMetadata table, Map<String, Object> updates) throws CatalogException {
        TableSpec existingSpec = table.spec();
        TableDefn defn = this.resolveDefn(existingSpec.type());
        Map revised = defn.mergeProperties(existingSpec.properties(), updates);
        try {
            defn.validate(revised, this.catalog.jsonMapper());
        }
        catch (IAE e) {
            throw CatalogException.badRequest(e.getMessage(), new Object[0]);
        }
        return existingSpec.withProperties(revised);
    }

    private TableDefn resolveDefn(String tableType) throws CatalogException {
        TableDefn defn = this.catalog.tableRegistry().defnFor(tableType);
        if (defn == null) {
            throw new CatalogException("Invalid table spec", Response.Status.INTERNAL_SERVER_ERROR, "Table %s has an invalid type [%s]", this.id.sqlName(), tableType);
        }
        return defn;
    }

    private long updateColumns(List<ColumnSpec> updates) throws CatalogException {
        if (CollectionUtils.isNullOrEmpty(updates)) {
            return 0L;
        }
        return this.catalog.tables().updateColumns(this.id, table -> this.applyUpdateColumns(table, updates));
    }

    private TableSpec applyUpdateColumns(TableMetadata table, List<ColumnSpec> updates) throws CatalogException {
        TableSpec existingSpec = table.spec();
        TableDefn defn = this.resolveDefn(existingSpec.type());
        List revised = defn.mergeColumns(existingSpec.columns(), updates);
        try {
            defn.validateColumns(revised, this.catalog.jsonMapper());
        }
        catch (IAE e) {
            throw CatalogException.badRequest(e.getMessage(), new Object[0]);
        }
        return existingSpec.withColumns(revised);
    }

    private long moveColumn(TableEditRequest.MoveColumn moveColumn) throws CatalogException {
        if (Strings.isNullOrEmpty((String)moveColumn.column)) {
            throw CatalogException.badRequest("A column name is required", new Object[0]);
        }
        if (moveColumn.where == null) {
            throw CatalogException.badRequest("A target location is required", new Object[0]);
        }
        if ((moveColumn.where == TableEditRequest.MoveColumn.Position.BEFORE || moveColumn.where == TableEditRequest.MoveColumn.Position.AFTER) && Strings.isNullOrEmpty((String)moveColumn.anchor)) {
            throw CatalogException.badRequest("A anchor column is required for BEFORE or AFTER", new Object[0]);
        }
        return this.catalog.tables().updateColumns(this.id, table -> this.applyMoveColumn(table, moveColumn));
    }

    private TableSpec applyMoveColumn(TableMetadata table, TableEditRequest.MoveColumn moveColumn) throws CatalogException {
        int anchorPosn;
        TableSpec existingSpec = table.spec();
        List existingCols = existingSpec.columns();
        ArrayList<ColumnSpec> revised = new ArrayList<ColumnSpec>(existingCols);
        int colPosn = TableEditor.findColumn(existingCols, moveColumn.column);
        if (colPosn == -1) {
            throw CatalogException.badRequest("Column [%s] is not defined", moveColumn.column);
        }
        if (moveColumn.where == TableEditRequest.MoveColumn.Position.BEFORE || moveColumn.where == TableEditRequest.MoveColumn.Position.AFTER) {
            anchorPosn = TableEditor.findColumn(existingCols, moveColumn.anchor);
            if (anchorPosn == -1) {
                throw CatalogException.badRequest("Anchor [%s] is not defined", moveColumn.column);
            }
            if (anchorPosn > colPosn) {
                --anchorPosn;
            }
        } else {
            anchorPosn = -1;
        }
        ColumnSpec col = (ColumnSpec)revised.remove(colPosn);
        switch (moveColumn.where) {
            case FIRST: {
                revised.add(0, col);
                break;
            }
            case LAST: {
                revised.add(col);
                break;
            }
            case BEFORE: {
                revised.add(anchorPosn, col);
                break;
            }
            case AFTER: {
                revised.add(anchorPosn + 1, col);
            }
        }
        return existingSpec.withColumns(revised);
    }

    private static int findColumn(List<ColumnSpec> columns, String colName) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).name().equals(colName)) continue;
            return i;
        }
        return -1;
    }
}

