/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.opencsv.RFC4180Parser;
import com.opencsv.RFC4180ParserBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.msq.exec.ClusterStatisticsMergeMode;
import org.apache.druid.msq.kernel.WorkerAssignmentStrategy;
import org.apache.druid.msq.sql.MSQMode;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.segment.IndexSpec;

public class MultiStageQueryContext {
    public static final String CTX_MSQ_MODE = "mode";
    public static final String DEFAULT_MSQ_MODE = MSQMode.STRICT_MODE.toString();
    public static final String CTX_MAX_NUM_TASKS = "maxNumTasks";
    @VisibleForTesting
    static final int DEFAULT_MAX_NUM_TASKS = 2;
    public static final String CTX_TASK_ASSIGNMENT_STRATEGY = "taskAssignment";
    private static final String DEFAULT_TASK_ASSIGNMENT_STRATEGY = WorkerAssignmentStrategy.MAX.toString();
    public static final String CTX_FINALIZE_AGGREGATIONS = "finalizeAggregations";
    private static final boolean DEFAULT_FINALIZE_AGGREGATIONS = true;
    public static final String CTX_ENABLE_DURABLE_SHUFFLE_STORAGE = "durableShuffleStorage";
    public static final String CTX_CLUSTER_STATISTICS_MERGE_MODE = "clusterStatisticsMergeMode";
    public static final String DEFAULT_CLUSTER_STATISTICS_MERGE_MODE = ClusterStatisticsMergeMode.PARALLEL.toString();
    private static final boolean DEFAULT_ENABLE_DURABLE_SHUFFLE_STORAGE = false;
    public static final String CTX_DESTINATION = "destination";
    private static final String DEFAULT_DESTINATION = null;
    public static final String CTX_ROWS_PER_SEGMENT = "rowsPerSegment";
    public static final String CTX_ROWS_IN_MEMORY = "rowsInMemory";
    public static final String CTX_SORT_ORDER = "segmentSortOrder";
    public static final String CTX_INDEX_SPEC = "indexSpec";
    private static final Pattern LOOKS_LIKE_JSON_ARRAY = Pattern.compile("^\\s*\\[.*", 32);

    public static String getMSQMode(QueryContext queryContext) {
        return queryContext.getString(CTX_MSQ_MODE, DEFAULT_MSQ_MODE);
    }

    public static boolean isDurableStorageEnabled(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_ENABLE_DURABLE_SHUFFLE_STORAGE, false);
    }

    public static ClusterStatisticsMergeMode getClusterStatisticsMergeMode(QueryContext queryContext) {
        return ClusterStatisticsMergeMode.valueOf(String.valueOf(queryContext.getString(CTX_CLUSTER_STATISTICS_MERGE_MODE, DEFAULT_CLUSTER_STATISTICS_MERGE_MODE)));
    }

    public static boolean isFinalizeAggregations(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_FINALIZE_AGGREGATIONS, true);
    }

    public static WorkerAssignmentStrategy getAssignmentStrategy(QueryContext queryContext) {
        String assignmentStrategyString = queryContext.getString(CTX_TASK_ASSIGNMENT_STRATEGY, DEFAULT_TASK_ASSIGNMENT_STRATEGY);
        return WorkerAssignmentStrategy.fromString(assignmentStrategyString);
    }

    public static int getMaxNumTasks(QueryContext queryContext) {
        return queryContext.getInt(CTX_MAX_NUM_TASKS, 2);
    }

    public static Object getDestination(QueryContext queryContext) {
        return queryContext.get(CTX_DESTINATION, (Object)DEFAULT_DESTINATION);
    }

    public static int getRowsPerSegment(QueryContext queryContext, int defaultRowsPerSegment) {
        return queryContext.getInt(CTX_ROWS_PER_SEGMENT, defaultRowsPerSegment);
    }

    public static int getRowsInMemory(QueryContext queryContext, int defaultRowsInMemory) {
        return queryContext.getInt(CTX_ROWS_IN_MEMORY, defaultRowsInMemory);
    }

    public static List<String> getSortOrder(QueryContext queryContext) {
        return MultiStageQueryContext.decodeSortOrder(queryContext.getString(CTX_SORT_ORDER));
    }

    @Nullable
    public static IndexSpec getIndexSpec(QueryContext queryContext, ObjectMapper objectMapper) {
        return MultiStageQueryContext.decodeIndexSpec(queryContext.get(CTX_INDEX_SPEC), objectMapper);
    }

    @Nullable
    @VisibleForTesting
    static List<String> decodeSortOrder(@Nullable String sortOrderString) {
        if (sortOrderString == null) {
            return Collections.emptyList();
        }
        if (LOOKS_LIKE_JSON_ARRAY.matcher(sortOrderString).matches()) {
            try {
                return (List)new ObjectMapper().readValue(sortOrderString, (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (JsonProcessingException e) {
                throw QueryContexts.badValueException((String)CTX_SORT_ORDER, (String)"CSV or JSON array", (Object)sortOrderString);
            }
        }
        RFC4180Parser csvParser = new RFC4180ParserBuilder().withSeparator(',').build();
        try {
            return Arrays.stream(csvParser.parseLine(sortOrderString)).filter(s -> s != null && !s.isEmpty()).map(String::trim).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw QueryContexts.badValueException((String)CTX_SORT_ORDER, (String)"CSV or JSON array", (Object)sortOrderString);
        }
    }

    @Nullable
    @VisibleForTesting
    static IndexSpec decodeIndexSpec(@Nullable Object indexSpecObject, ObjectMapper objectMapper) {
        try {
            if (indexSpecObject == null) {
                return null;
            }
            if (indexSpecObject instanceof String) {
                return (IndexSpec)objectMapper.readValue((String)indexSpecObject, IndexSpec.class);
            }
            return (IndexSpec)objectMapper.convertValue(indexSpecObject, IndexSpec.class);
        }
        catch (Exception e) {
            throw QueryContexts.badValueException((String)CTX_INDEX_SPEC, (String)"an indexSpec", (Object)indexSpecObject);
        }
    }
}

