/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.util;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;

public class MSQTaskQueryMakerUtils {
    public static final Set<String> SENSISTIVE_JSON_KEYS = ImmutableSet.of((Object)"accessKeyId", (Object)"secretAccessKey");
    public static final Set<Pattern> SENSITIVE_KEYS_REGEX_PATTERNS = SENSISTIVE_JSON_KEYS.stream().map(sensitiveKey -> Pattern.compile(StringUtils.format((String)"\\\\\"%s\\\\\"(\\s)*:(\\s)*(?<sensitive>\\{(\\s)*(\\S)+?(\\s)*\\})", (Object[])new Object[]{sensitiveKey}), 2)).collect(Collectors.toSet());

    public static String maskSensitiveJsonKeys(String sqlQuery) {
        StringBuilder maskedSqlQuery = new StringBuilder(sqlQuery);
        for (Pattern p : SENSITIVE_KEYS_REGEX_PATTERNS) {
            Matcher m = p.matcher(sqlQuery);
            while (m.find()) {
                String sensitiveData = m.group("sensitive");
                int start = maskedSqlQuery.indexOf(sensitiveData);
                int end = start + sensitiveData.length();
                maskedSqlQuery.replace(start, end, "<masked>");
            }
        }
        return maskedSqlQuery.toString();
    }

    public static void validateSegmentSortOrder(List<String> sortOrder, Collection<String> allOutputColumns) {
        HashSet<String> allOutputColumnsSet = new HashSet<String>(allOutputColumns);
        for (String column : sortOrder) {
            if (allOutputColumnsSet.contains(column)) continue;
            throw new IAE("Column [%s] in segment sort order does not appear in the query output", new Object[]{column});
        }
        if (sortOrder.size() > 0 && allOutputColumns.contains("__time") && !"__time".equals(sortOrder.get(0))) {
            throw new IAE("Segment sort order must begin with column [%s]", new Object[]{"__time"});
        }
    }
}

