/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.util;

import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;

public class DimensionSchemaUtils {
    public static DimensionSchema createDimensionSchema(String column, @Nullable ColumnType type) {
        if (type == null) {
            return new StringDimensionSchema(column);
        }
        switch ((ValueType)type.getType()) {
            case STRING: {
                return new StringDimensionSchema(column);
            }
            case LONG: {
                return new LongDimensionSchema(column);
            }
            case FLOAT: {
                return new FloatDimensionSchema(column);
            }
            case DOUBLE: {
                return new DoubleDimensionSchema(column);
            }
            case ARRAY: {
                switch ((ValueType)type.getElementType().getType()) {
                    case STRING: {
                        return new StringDimensionSchema(column, DimensionSchema.MultiValueHandling.ARRAY, null);
                    }
                }
                throw new ISE("Cannot create dimension for type [%s]", new Object[]{type.toString()});
            }
        }
        ColumnCapabilitiesImpl capabilities = ColumnCapabilitiesImpl.createDefault().setType(type);
        return DimensionHandlerUtils.getHandlerFromCapabilities((String)column, (ColumnCapabilities)capabilities, null).getDimensionSchema((ColumnCapabilities)capabilities);
    }
}

