/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.statistics.KeyCollectorFactory;
import org.apache.druid.msq.statistics.QuantilesSketchKeyCollector;
import org.apache.druid.msq.statistics.QuantilesSketchKeyCollectorSnapshot;

public class QuantilesSketchKeyCollectorFactory
implements KeyCollectorFactory<QuantilesSketchKeyCollector, QuantilesSketchKeyCollectorSnapshot> {
    @VisibleForTesting
    static final int SKETCH_INITIAL_K = 32768;
    private final Comparator<byte[]> comparator;

    private QuantilesSketchKeyCollectorFactory(Comparator<byte[]> comparator) {
        this.comparator = comparator;
    }

    static QuantilesSketchKeyCollectorFactory create(ClusterBy clusterBy) {
        return new QuantilesSketchKeyCollectorFactory(clusterBy.byteKeyComparator());
    }

    @Override
    public QuantilesSketchKeyCollector newKeyCollector() {
        return new QuantilesSketchKeyCollector(this.comparator, (ItemsSketch<byte[]>)ItemsSketch.getInstance((int)32768, this.comparator), 0.0);
    }

    @Override
    public JsonDeserializer<QuantilesSketchKeyCollectorSnapshot> snapshotDeserializer() {
        return new JsonDeserializer<QuantilesSketchKeyCollectorSnapshot>(){

            public QuantilesSketchKeyCollectorSnapshot deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return (QuantilesSketchKeyCollectorSnapshot)jp.readValueAs(QuantilesSketchKeyCollectorSnapshot.class);
            }
        };
    }

    @Override
    public QuantilesSketchKeyCollectorSnapshot toSnapshot(QuantilesSketchKeyCollector collector) {
        String encodedSketch = StringUtils.encodeBase64String((byte[])collector.getSketch().toByteArray((ArrayOfItemsSerDe)ByteRowKeySerde.INSTANCE));
        return new QuantilesSketchKeyCollectorSnapshot(encodedSketch, collector.getAverageKeyLength());
    }

    @Override
    public QuantilesSketchKeyCollector fromSnapshot(QuantilesSketchKeyCollectorSnapshot snapshot) {
        String encodedSketch = snapshot.getEncodedSketch();
        byte[] bytes = StringUtils.decodeBase64String((String)encodedSketch);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes), this.comparator, (ArrayOfItemsSerDe)ByteRowKeySerde.INSTANCE);
        return new QuantilesSketchKeyCollector(this.comparator, (ItemsSketch<byte[]>)sketch, snapshot.getAverageKeyLength());
    }

    private static class ByteRowKeySerde
    extends ArrayOfItemsSerDe<byte[]> {
        private static final ByteRowKeySerde INSTANCE = new ByteRowKeySerde();

        private ByteRowKeySerde() {
        }

        public byte[] serializeToByteArray(byte[][] items) {
            int serializedSize = 4 * items.length;
            for (byte[] key : items) {
                serializedSize += key.length;
            }
            byte[] serializedBytes = new byte[serializedSize];
            WritableMemory writableMemory = WritableMemory.writableWrap((byte[])serializedBytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            long keyWritePosition = 4L * (long)items.length;
            for (int i = 0; i < items.length; ++i) {
                byte[] keyBytes = items[i];
                writableMemory.putInt(4L * (long)i, keyBytes.length);
                writableMemory.putByteArray(keyWritePosition, keyBytes, 0, keyBytes.length);
                keyWritePosition += (long)keyBytes.length;
            }
            assert (keyWritePosition == (long)serializedSize);
            return serializedBytes;
        }

        public byte[][] deserializeFromMemory(Memory mem, int numItems) {
            byte[][] keys = new byte[numItems][];
            long keyPosition = 4L * (long)numItems;
            for (int i = 0; i < numItems; ++i) {
                int keyLength = mem.getInt(4L * (long)i);
                byte[] keyBytes = new byte[keyLength];
                mem.getByteArray(keyPosition, keyBytes, 0, keyLength);
                keys[i] = keyBytes;
                keyPosition += (long)keyLength;
            }
            return keys;
        }
    }
}

