/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.msq.statistics.KeyCollectorSnapshot;

@JsonTypeName(value="distinct")
public class DistinctKeySnapshot
implements KeyCollectorSnapshot {
    static final String TYPE = "distinct";
    private final List<SerializablePair<RowKey, Long>> keys;
    private final int spaceReductionFactor;

    @JsonCreator
    DistinctKeySnapshot(@JsonProperty(value="keys") List<SerializablePair<RowKey, Long>> keys, @JsonProperty(value="spaceReductionFactor") int spaceReductionFactor) {
        this.keys = (List)Preconditions.checkNotNull(keys, (Object)"keys");
        this.spaceReductionFactor = spaceReductionFactor;
    }

    @JsonProperty
    public List<SerializablePair<RowKey, Long>> getKeys() {
        return this.keys;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getSpaceReductionFactor() {
        return this.spaceReductionFactor;
    }

    public Map<RowKey, Long> getKeysAsMap() {
        HashMap<RowKey, Long> keysMap = new HashMap<RowKey, Long>();
        for (SerializablePair<RowKey, Long> key : this.keys) {
            keysMap.put((RowKey)key.lhs, (Long)key.rhs);
        }
        return keysMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistinctKeySnapshot that = (DistinctKeySnapshot)o;
        return this.spaceReductionFactor == that.spaceReductionFactor && Objects.equals(this.getKeysAsMap(), that.getKeysAsMap());
    }

    public int hashCode() {
        return Objects.hash(this.getKeysAsMap(), this.spaceReductionFactor);
    }
}

