/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import it.unimi.dsi.fastutil.objects.Object2LongRBTreeMap;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMap;
import java.io.IOException;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.msq.statistics.DistinctKeyCollector;
import org.apache.druid.msq.statistics.DistinctKeySnapshot;
import org.apache.druid.msq.statistics.KeyCollectorFactory;

public class DistinctKeyCollectorFactory
implements KeyCollectorFactory<DistinctKeyCollector, DistinctKeySnapshot> {
    private final Comparator<RowKey> comparator;

    private DistinctKeyCollectorFactory(Comparator<RowKey> comparator) {
        this.comparator = comparator;
    }

    static DistinctKeyCollectorFactory create(ClusterBy clusterBy) {
        return new DistinctKeyCollectorFactory(clusterBy.keyComparator());
    }

    @Override
    public DistinctKeyCollector newKeyCollector() {
        return new DistinctKeyCollector(this.comparator);
    }

    @Override
    public JsonDeserializer<DistinctKeySnapshot> snapshotDeserializer() {
        return new JsonDeserializer<DistinctKeySnapshot>(){

            public DistinctKeySnapshot deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return (DistinctKeySnapshot)jp.readValueAs(DistinctKeySnapshot.class);
            }
        };
    }

    @Override
    public DistinctKeySnapshot toSnapshot(DistinctKeyCollector collector) {
        return new DistinctKeySnapshot(collector.getRetainedKeys().entrySet().stream().map(entry -> new SerializablePair(entry.getKey(), entry.getValue())).collect(Collectors.toList()), collector.getSpaceReductionFactor());
    }

    @Override
    public DistinctKeyCollector fromSnapshot(DistinctKeySnapshot snapshot) {
        Object2LongRBTreeMap retainedKeys = new Object2LongRBTreeMap(this.comparator);
        retainedKeys.putAll(snapshot.getKeysAsMap());
        return new DistinctKeyCollector(this.comparator, (Object2LongSortedMap<RowKey>)retainedKeys, snapshot.getSpaceReductionFactor());
    }
}

