/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Comparator;
import java.util.Optional;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.msq.statistics.DelegateOrMinKeyCollector;
import org.apache.druid.msq.statistics.DelegateOrMinKeyCollectorSnapshot;
import org.apache.druid.msq.statistics.KeyCollector;
import org.apache.druid.msq.statistics.KeyCollectorFactory;
import org.apache.druid.msq.statistics.KeyCollectorSnapshot;

public class DelegateOrMinKeyCollectorFactory<TDelegate extends KeyCollector<TDelegate>, TSnapshot extends KeyCollectorSnapshot>
implements KeyCollectorFactory<DelegateOrMinKeyCollector<TDelegate>, DelegateOrMinKeyCollectorSnapshot<TSnapshot>> {
    private final Comparator<RowKey> comparator;
    private final KeyCollectorFactory<TDelegate, TSnapshot> delegateFactory;

    public DelegateOrMinKeyCollectorFactory(Comparator<RowKey> comparator, KeyCollectorFactory<TDelegate, TSnapshot> delegateFactory) {
        this.comparator = comparator;
        this.delegateFactory = delegateFactory;
    }

    @Override
    public DelegateOrMinKeyCollector<TDelegate> newKeyCollector() {
        return new DelegateOrMinKeyCollector<TDelegate>(this.comparator, this.delegateFactory.newKeyCollector(), null);
    }

    @Override
    public JsonDeserializer<DelegateOrMinKeyCollectorSnapshot<TSnapshot>> snapshotDeserializer() {
        final JsonDeserializer<TSnapshot> delegateDeserializer = this.delegateFactory.snapshotDeserializer();
        return new JsonDeserializer<DelegateOrMinKeyCollectorSnapshot<TSnapshot>>(){

            public DelegateOrMinKeyCollectorSnapshot<TSnapshot> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                JsonToken token;
                KeyCollectorSnapshot delegateSnapshot = null;
                RowKey minKey = null;
                if (!jp.isExpectedStartObjectToken()) {
                    ctxt.reportWrongTokenException((JsonDeserializer)this, JsonToken.START_OBJECT, null, new Object[0]);
                }
                while ((token = jp.nextToken()) != JsonToken.END_OBJECT) {
                    if (token != JsonToken.FIELD_NAME) {
                        ctxt.reportWrongTokenException((JsonDeserializer)this, JsonToken.FIELD_NAME, null, new Object[0]);
                    }
                    String fieldName = jp.getText();
                    jp.nextToken();
                    if ("snapshot".equals(fieldName)) {
                        delegateSnapshot = (KeyCollectorSnapshot)delegateDeserializer.deserialize(jp, ctxt);
                        continue;
                    }
                    if (!"minKey".equals(fieldName)) continue;
                    minKey = (RowKey)jp.readValueAs(RowKey.class);
                }
                return new DelegateOrMinKeyCollectorSnapshot<Object>(delegateSnapshot, minKey);
            }
        };
    }

    @Override
    public DelegateOrMinKeyCollectorSnapshot<TSnapshot> toSnapshot(DelegateOrMinKeyCollector<TDelegate> collector) {
        RowKey minKeyForSnapshot = !collector.getDelegate().isPresent() && !collector.isEmpty() ? collector.minKey() : null;
        return new DelegateOrMinKeyCollectorSnapshot<KeyCollectorSnapshot>(collector.getDelegate().map(this.delegateFactory::toSnapshot).orElse(null), minKeyForSnapshot);
    }

    @Override
    public DelegateOrMinKeyCollector<TDelegate> fromSnapshot(DelegateOrMinKeyCollectorSnapshot<TSnapshot> snapshot) {
        return new DelegateOrMinKeyCollector<KeyCollector>(this.comparator, Optional.ofNullable(snapshot.getSnapshot()).map(this.delegateFactory::fromSnapshot).orElse(null), snapshot.getMinKey());
    }
}

