/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import com.google.common.collect.ImmutableSortedMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;

public class CompleteKeyStatisticsInformation {
    private final SortedMap<Long, Set<Integer>> timeSegmentVsWorkerMap;
    private boolean multipleValues;
    private double bytesRetained;

    public CompleteKeyStatisticsInformation(SortedMap<Long, Set<Integer>> timeChunks, boolean multipleValues, double bytesRetained) {
        this.timeSegmentVsWorkerMap = timeChunks;
        this.multipleValues = multipleValues;
        this.bytesRetained = bytesRetained;
    }

    public void mergePartialInformation(int workerNumber, PartialKeyStatisticsInformation partialKeyStatisticsInformation) {
        for (Long timeSegment : partialKeyStatisticsInformation.getTimeSegments()) {
            this.timeSegmentVsWorkerMap.computeIfAbsent(timeSegment, key -> new HashSet()).add(workerNumber);
        }
        this.multipleValues = this.multipleValues || partialKeyStatisticsInformation.hasMultipleValues();
        this.bytesRetained += this.bytesRetained;
    }

    public SortedMap<Long, Set<Integer>> getTimeSegmentVsWorkerMap() {
        return ImmutableSortedMap.copyOfSorted(this.timeSegmentVsWorkerMap);
    }

    public boolean hasMultipleValues() {
        return this.multipleValues;
    }

    public double getBytesRetained() {
        return this.bytesRetained;
    }
}

