/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.query.QueryException;

public class SqlTaskStatus {
    private final String taskId;
    private final TaskState state;
    @Nullable
    private final QueryException error;

    @JsonCreator
    public SqlTaskStatus(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="state") TaskState state, @JsonProperty(value="error") @Nullable QueryException error) {
        this.taskId = (String)Preconditions.checkNotNull((Object)taskId, (Object)"taskId");
        this.state = (TaskState)Preconditions.checkNotNull((Object)state, (Object)"state");
        this.error = error;
    }

    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @JsonProperty
    public TaskState getState() {
        return this.state;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public QueryException getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTaskStatus response = (SqlTaskStatus)o;
        return Objects.equals(this.taskId, response.taskId) && this.state == response.state && Objects.equals(this.error, response.error);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.state, this.error);
    }

    public String toString() {
        return "SqlTaskStatus{taskId='" + this.taskId + '\'' + ", state=" + this.state + ", error=" + this.error + '}';
    }
}

