/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CountingOutputStream;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.druid.common.exception.SanitizableException;
import org.apache.druid.guice.annotations.MSQ;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.sql.MSQTaskSqlEngine;
import org.apache.druid.msq.sql.SqlTaskStatus;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.SqlPlanningException;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlQuery;

@Path(value="/druid/v2/sql/task/")
public class SqlTaskResource {
    private static final Logger log = new Logger(SqlTaskResource.class);
    private final SqlStatementFactory sqlStatementFactory;
    private final ServerConfig serverConfig;
    private final AuthorizerMapper authorizerMapper;
    private final ObjectMapper jsonMapper;

    @Inject
    public SqlTaskResource(@MSQ SqlStatementFactory sqlStatementFactory, ServerConfig serverConfig, AuthorizerMapper authorizerMapper, ObjectMapper jsonMapper) {
        this.sqlStatementFactory = sqlStatementFactory;
        this.serverConfig = serverConfig;
        this.authorizerMapper = authorizerMapper;
        this.jsonMapper = jsonMapper;
    }

    @GET
    @Path(value="/enabled")
    @Produces(value={"application/json"})
    public Response doGetEnabled(@Context HttpServletRequest request) {
        Access authResult = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)request, Collections.emptyList(), (AuthorizerMapper)this.authorizerMapper);
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        return Response.ok((Object)ImmutableMap.of((Object)"enabled", (Object)true)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response doPost(SqlQuery sqlQuery, @Context HttpServletRequest req) {
        QueryResponse response;
        HttpStatement stmt = this.sqlStatementFactory.httpStatement(sqlQuery, req);
        String sqlQueryId = stmt.sqlQueryId();
        try {
            DirectStatement.ResultSet plan = stmt.plan();
            response = plan.run();
            Sequence sequence = response.getResults();
            SqlRowTransformer rowTransformer = plan.createRowTransformer();
            boolean isTaskStruct = MSQTaskSqlEngine.TASK_STRUCT_FIELD_NAMES.equals(rowTransformer.getFieldList());
            if (isTaskStruct) {
                Response response2 = this.buildTaskResponse((Sequence<Object[]>)sequence);
                return response2;
            }
            Response response3 = this.buildStandardResponse((Sequence<Object[]>)sequence, sqlQuery, sqlQueryId, rowTransformer);
            return response3;
        }
        catch (QueryCapacityExceededException cap) {
            stmt.reporter().failed((Throwable)cap);
            response = this.buildNonOkResponse(429, (SanitizableException)cap, sqlQueryId);
            return response;
        }
        catch (QueryUnsupportedException unsupported) {
            stmt.reporter().failed((Throwable)unsupported);
            response = this.buildNonOkResponse(501, (SanitizableException)unsupported, sqlQueryId);
            return response;
        }
        catch (QueryTimeoutException timeout) {
            stmt.reporter().failed((Throwable)timeout);
            response = this.buildNonOkResponse(504, (SanitizableException)timeout, sqlQueryId);
            return response;
        }
        catch (ResourceLimitExceededException | SqlPlanningException e) {
            stmt.reporter().failed(e);
            response = this.buildNonOkResponse(400, (SanitizableException)e, sqlQueryId);
            return response;
        }
        catch (ForbiddenException e) {
            throw (ForbiddenException)((Object)this.serverConfig.getErrorResponseTransformStrategy().transformIfNeeded((SanitizableException)e));
        }
        catch (RelOptPlanner.CannotPlanException e) {
            stmt.reporter().failed((Throwable)e);
            SqlPlanningException spe = new SqlPlanningException(SqlPlanningException.PlanningError.UNSUPPORTED_SQL_ERROR, e.getMessage());
            Response response4 = this.buildNonOkResponse(400, (SanitizableException)spe, sqlQueryId);
            return response4;
        }
        catch (Throwable e) {
            stmt.reporter().failed(e);
            log.noStackTrace().warn(e, "Failed to handle query: %s", new Object[]{sqlQueryId});
            Response response5 = this.buildNonOkResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (SanitizableException)QueryInterruptedException.wrapIfNeeded((Throwable)e), sqlQueryId);
            return response5;
        }
        finally {
            stmt.close();
        }
    }

    private Response buildTaskResponse(Sequence<Object[]> sequence) throws IOException {
        String taskId = null;
        try (Yielder yielder = Yielders.each(sequence);){
            while (!yielder.isDone()) {
                Object[] row = (Object[])yielder.get();
                if (taskId == null && row.length > 0) {
                    taskId = (String)row[0];
                }
                yielder = yielder.next(null);
            }
        }
        if (taskId == null) {
            return this.genericError(Response.Status.INTERNAL_SERVER_ERROR, "Internal error", "Failed to issue query task", null);
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new SqlTaskStatus(taskId, TaskState.RUNNING, null)).build();
    }

    private Response buildStandardResponse(Sequence<Object[]> sequence, SqlQuery sqlQuery, String sqlQueryId, SqlRowTransformer rowTransformer) throws IOException {
        Yielder yielder0 = Yielders.each(sequence);
        try {
            Response.ResponseBuilder responseBuilder = Response.ok(outputStream -> {
                CountingOutputStream os = new CountingOutputStream(outputStream);
                try (Yielder yielder = yielder0;
                     ResultFormat.Writer writer = sqlQuery.getResultFormat().createFormatter((OutputStream)os, this.jsonMapper);){
                    writer.writeResponseStart();
                    if (sqlQuery.includeHeader()) {
                        writer.writeHeader(rowTransformer.getRowType(), sqlQuery.includeTypesHeader(), sqlQuery.includeSqlTypesHeader());
                    }
                    while (!yielder.isDone()) {
                        Object[] row = (Object[])yielder.get();
                        writer.writeRowStart();
                        for (int i = 0; i < rowTransformer.getFieldList().size(); ++i) {
                            Object value = rowTransformer.transform(row, i);
                            writer.writeRowField((String)rowTransformer.getFieldList().get(i), value);
                        }
                        writer.writeRowEnd();
                        yielder = yielder.next(null);
                    }
                    writer.writeResponseEnd();
                }
            });
            if (sqlQuery.includeHeader()) {
                responseBuilder.header("X-Druid-SQL-Header-Included", (Object)"yes");
            }
            return responseBuilder.build();
        }
        catch (Throwable e) {
            yielder0.close();
            throw e;
        }
    }

    private Response buildNonOkResponse(int status, SanitizableException e, String sqlQueryId) {
        QueryException cleaned = (QueryException)this.serverConfig.getErrorResponseTransformStrategy().transformIfNeeded(e);
        return Response.status((int)status).entity((Object)new SqlTaskStatus(sqlQueryId, TaskState.FAILED, cleaned)).build();
    }

    private Response genericError(Response.Status status, String code, String msg, String id) {
        return Response.status((Response.Status)status).entity((Object)new SqlTaskStatus(id, TaskState.FAILED, new QueryException("FAILED", msg, null, null))).build();
    }
}

