/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.sql.MSQTaskQueryMaker;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.NativeSqlEngine;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngines;

public class MSQTaskSqlEngine
implements SqlEngine {
    public static final Set<String> SYSTEM_CONTEXT_PARAMETERS = ImmutableSet.builder().addAll((Iterable)NativeSqlEngine.SYSTEM_CONTEXT_PARAMETERS).add((Object)"destination").add((Object)"__timeColumn").build();
    public static final List<String> TASK_STRUCT_FIELD_NAMES = ImmutableList.of((Object)"TASK");
    private static final String NAME = "msq-task";
    private final OverlordClient overlordClient;
    private final ObjectMapper jsonMapper;

    @Inject
    public MSQTaskSqlEngine(OverlordClient overlordClient, ObjectMapper jsonMapper) {
        this.overlordClient = overlordClient;
        this.jsonMapper = jsonMapper;
    }

    public String name() {
        return NAME;
    }

    public void validateContext(Map<String, Object> queryContext) throws ValidationException {
        SqlEngines.validateNoSpecialContextKeys(queryContext, SYSTEM_CONTEXT_PARAMETERS);
    }

    public RelDataType resultTypeForSelect(RelDataTypeFactory typeFactory, RelDataType validatedRowType) {
        return MSQTaskSqlEngine.getMSQStructType(typeFactory);
    }

    public RelDataType resultTypeForInsert(RelDataTypeFactory typeFactory, RelDataType validatedRowType) {
        return MSQTaskSqlEngine.getMSQStructType(typeFactory);
    }

    public boolean feature(EngineFeature feature, PlannerContext plannerContext) {
        switch (feature) {
            case ALLOW_BINDABLE_PLAN: 
            case TIMESERIES_QUERY: 
            case TOPN_QUERY: 
            case TIME_BOUNDARY_QUERY: {
                return false;
            }
            case CAN_SELECT: 
            case CAN_INSERT: 
            case CAN_REPLACE: 
            case READ_EXTERNAL_DATA: 
            case SCAN_ORDER_BY_NON_TIME: 
            case SCAN_NEEDS_SIGNATURE: {
                return true;
            }
        }
        throw new IAE("Unrecognized feature: %s", new Object[]{feature});
    }

    public QueryMaker buildQueryMakerForSelect(RelRoot relRoot, PlannerContext plannerContext) throws ValidationException {
        MSQTaskSqlEngine.validateSelect((List<Pair<Integer, String>>)relRoot.fields, plannerContext);
        return new MSQTaskQueryMaker(null, this.overlordClient, plannerContext, this.jsonMapper, (List<Pair<Integer, String>>)relRoot.fields);
    }

    public QueryMaker buildQueryMakerForInsert(String targetDataSource, RelRoot relRoot, PlannerContext plannerContext) throws ValidationException {
        MSQTaskSqlEngine.validateInsert(relRoot.rel, (List<Pair<Integer, String>>)relRoot.fields, plannerContext);
        return new MSQTaskQueryMaker(targetDataSource, this.overlordClient, plannerContext, this.jsonMapper, (List<Pair<Integer, String>>)relRoot.fields);
    }

    private static void validateSelect(List<Pair<Integer, String>> fieldMappings, PlannerContext plannerContext) throws ValidationException {
        MSQTaskSqlEngine.validateNoDuplicateAliases(fieldMappings);
        if (plannerContext.queryContext().containsKey("sqlInsertSegmentGranularity")) {
            throw new ValidationException(StringUtils.format((String)"Cannot use \"%s\" without INSERT", (Object[])new Object[]{"sqlInsertSegmentGranularity"}));
        }
    }

    private static void validateInsert(RelNode rootRel, List<Pair<Integer, String>> fieldMappings, PlannerContext plannerContext) throws ValidationException {
        Granularity segmentGranularity;
        MSQTaskSqlEngine.validateNoDuplicateAliases(fieldMappings);
        int timeFieldIndex = -1;
        for (Pair<Integer, String> field : fieldMappings) {
            if (!((String)field.right).equals("__time")) continue;
            timeFieldIndex = (Integer)field.left;
            SqlTypeName timeType = ((RelDataTypeField)rootRel.getRowType().getFieldList().get((Integer)field.left)).getType().getSqlTypeName();
            if (timeType == SqlTypeName.TIMESTAMP) continue;
            throw new ValidationException(StringUtils.format((String)"Field \"%s\" must be of type TIMESTAMP (was %s)", (Object[])new Object[]{"__time", timeType}));
        }
        try {
            segmentGranularity = QueryKitUtils.getSegmentGranularityFromContext(plannerContext.getJsonMapper(), plannerContext.queryContextMap());
        }
        catch (Exception e) {
            throw new ValidationException(StringUtils.format((String)"Invalid segmentGranularity: %s", (Object[])new Object[]{plannerContext.queryContext().get("sqlInsertSegmentGranularity")}), (Throwable)e);
        }
        boolean hasSegmentGranularity = !Granularities.ALL.equals(segmentGranularity);
        MSQTaskSqlEngine.validateLimitAndOffset(rootRel, !hasSegmentGranularity);
        if (hasSegmentGranularity && timeFieldIndex < 0) {
            throw new ValidationException(StringUtils.format((String)"INSERT queries with segment granularity other than \"all\" must have a \"%s\" field.", (Object[])new Object[]{"__time"}));
        }
    }

    private static void validateNoDuplicateAliases(List<Pair<Integer, String>> fieldMappings) throws ValidationException {
        HashSet<Object> aliasesSeen = new HashSet<Object>();
        for (Pair<Integer, String> field : fieldMappings) {
            if (aliasesSeen.add(field.right)) continue;
            throw new ValidationException("Duplicate field in SELECT: " + (String)field.right);
        }
    }

    private static void validateLimitAndOffset(RelNode topRel, boolean limitOk) throws ValidationException {
        RelNode projectInput;
        Project project;
        Sort sort = null;
        if (topRel instanceof Sort) {
            sort = (Sort)topRel;
        } else if (topRel instanceof Project && (project = (Project)topRel).isMapping() && (projectInput = project.getInput()) instanceof Sort) {
            sort = (Sort)projectInput;
        }
        if (sort != null && sort.fetch != null && !limitOk) {
            throw new ValidationException("INSERT and REPLACE queries cannot have a LIMIT unless PARTITIONED BY is \"ALL\".");
        }
        if (sort != null && sort.offset != null) {
            throw new ValidationException("INSERT and REPLACE queries cannot have an OFFSET.");
        }
    }

    private static RelDataType getMSQStructType(RelDataTypeFactory typeFactory) {
        return typeFactory.createStructType((List)ImmutableList.of((Object)Calcites.createSqlType((RelDataTypeFactory)typeFactory, (SqlTypeName)SqlTypeName.VARCHAR)), TASK_STRUCT_FIELD_NAMES);
    }
}

