/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.indexing.ColumnMapping;
import org.apache.druid.msq.indexing.ColumnMappings;
import org.apache.druid.msq.indexing.DataSourceMSQDestination;
import org.apache.druid.msq.indexing.MSQControllerTask;
import org.apache.druid.msq.indexing.MSQDestination;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.TaskReportMSQDestination;
import org.apache.druid.msq.sql.MSQMode;
import org.apache.druid.msq.util.MSQTaskQueryMakerUtils;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.Grouping;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.joda.time.Interval;

public class MSQTaskQueryMaker
implements QueryMaker {
    private static final String DESTINATION_DATASOURCE = "dataSource";
    private static final String DESTINATION_REPORT = "taskReport";
    private static final Granularity DEFAULT_SEGMENT_GRANULARITY = Granularities.ALL;
    private static final int DEFAULT_ROWS_PER_SEGMENT = 3000000;
    private static final int DEFAULT_ROWS_IN_MEMORY = 100000;
    private final String targetDataSource;
    private final OverlordClient overlordClient;
    private final PlannerContext plannerContext;
    private final ObjectMapper jsonMapper;
    private final List<Pair<Integer, String>> fieldMapping;

    MSQTaskQueryMaker(@Nullable String targetDataSource, OverlordClient overlordClient, PlannerContext plannerContext, ObjectMapper jsonMapper, List<Pair<Integer, String>> fieldMapping) {
        this.targetDataSource = targetDataSource;
        this.overlordClient = (OverlordClient)Preconditions.checkNotNull((Object)overlordClient, (Object)"indexingServiceClient");
        this.plannerContext = (PlannerContext)Preconditions.checkNotNull((Object)plannerContext, (Object)"plannerContext");
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
        this.fieldMapping = (List)Preconditions.checkNotNull(fieldMapping, (Object)"fieldMapping");
    }

    public QueryResponse<Object[]> runQuery(DruidQuery druidQuery) {
        MSQDestination destination;
        Object segmentGranularity;
        String taskId = MSQTasks.controllerTaskId(this.plannerContext.getSqlQueryId());
        QueryContext queryContext = this.plannerContext.queryContext();
        String msqMode = MultiStageQueryContext.getMSQMode(queryContext);
        if (msqMode != null) {
            MSQMode.populateDefaultQueryContext(msqMode, this.plannerContext.queryContextMap());
        }
        String ctxDestination = DimensionHandlerUtils.convertObjectToString((Object)MultiStageQueryContext.getDestination(queryContext));
        try {
            segmentGranularity = Optional.ofNullable(this.plannerContext.queryContext().get("sqlInsertSegmentGranularity")).orElse(this.jsonMapper.writeValueAsString((Object)DEFAULT_SEGMENT_GRANULARITY));
        }
        catch (JsonProcessingException e) {
            throw new IAE("Unable to deserialize the insert granularity. Please retry the query with a valid segment graularity", new Object[0]);
        }
        int maxNumTasks = MultiStageQueryContext.getMaxNumTasks(queryContext);
        if (maxNumTasks < 2) {
            throw new IAE("maxNumTasks cannot be less than 2 since at least 1 controller and 1 worker is necessary.", new Object[0]);
        }
        int maxNumWorkers = maxNumTasks - 1;
        int rowsPerSegment = MultiStageQueryContext.getRowsPerSegment(queryContext, 3000000);
        int maxRowsInMemory = MultiStageQueryContext.getRowsInMemory(queryContext, 100000);
        IndexSpec indexSpec = MultiStageQueryContext.getIndexSpec(queryContext, this.jsonMapper);
        boolean finalizeAggregations = MultiStageQueryContext.isFinalizeAggregations(queryContext);
        List replaceTimeChunks = Optional.ofNullable(this.plannerContext.queryContext().get("sqlReplaceTimeChunks")).map(s -> {
            if (s instanceof String && "all".equals(StringUtils.toLowerCase((String)((String)s)))) {
                return Intervals.ONLY_ETERNITY;
            }
            String[] parts = ((String)s).split("\\s*,\\s*");
            ArrayList<Interval> intervals = new ArrayList<Interval>();
            for (String part : parts) {
                intervals.add(Intervals.of((String)part));
            }
            return intervals;
        }).orElse(null);
        Map<String, ColumnType> aggregationIntermediateTypeMap = finalizeAggregations ? null : MSQTaskQueryMaker.buildAggregationIntermediateTypeMap(druidQuery);
        ArrayList<String> sqlTypeNames = new ArrayList<String>();
        ArrayList<ColumnMapping> columnMappings = new ArrayList<ColumnMapping>();
        for (Pair<Integer, String> entry : this.fieldMapping) {
            SqlTypeName sqlTypeName;
            String queryColumn = druidQuery.getOutputRowSignature().getColumnName(((Integer)entry.getKey()).intValue());
            String outputColumns = (String)entry.getValue();
            if (!finalizeAggregations && aggregationIntermediateTypeMap.containsKey(queryColumn)) {
                ColumnType druidType = aggregationIntermediateTypeMap.get(queryColumn);
                sqlTypeName = new RowSignatures.ComplexSqlType(SqlTypeName.OTHER, druidType, true).getSqlTypeName();
            } else {
                sqlTypeName = ((RelDataTypeField)druidQuery.getOutputRowType().getFieldList().get((Integer)entry.getKey())).getType().getSqlTypeName();
            }
            sqlTypeNames.add(sqlTypeName.getName());
            columnMappings.add(new ColumnMapping(queryColumn, outputColumns));
        }
        if (this.targetDataSource != null) {
            Granularity segmentGranularityObject;
            if (ctxDestination != null && !DESTINATION_DATASOURCE.equals(ctxDestination)) {
                throw new IAE("Cannot INSERT with destination [%s]", new Object[]{ctxDestination});
            }
            try {
                segmentGranularityObject = (Granularity)this.jsonMapper.readValue((String)segmentGranularity, Granularity.class);
            }
            catch (Exception e) {
                throw new ISE("Unable to convert %s to a segment granularity", new Object[]{segmentGranularity});
            }
            List<String> segmentSortOrder = MultiStageQueryContext.getSortOrder(queryContext);
            MSQTaskQueryMakerUtils.validateSegmentSortOrder(segmentSortOrder, this.fieldMapping.stream().map(f -> (String)f.right).collect(Collectors.toList()));
            destination = new DataSourceMSQDestination(this.targetDataSource, segmentGranularityObject, segmentSortOrder, replaceTimeChunks);
        } else {
            if (ctxDestination != null && !DESTINATION_REPORT.equals(ctxDestination)) {
                throw new IAE("Cannot SELECT with destination [%s]", new Object[]{ctxDestination});
            }
            destination = TaskReportMSQDestination.instance();
        }
        HashMap<String, Boolean> nativeQueryContextOverrides = new HashMap<String, Boolean>();
        nativeQueryContextOverrides.put("finalize", finalizeAggregations);
        MSQSpec querySpec = MSQSpec.builder().query(druidQuery.getQuery().withOverriddenContext(nativeQueryContextOverrides)).columnMappings(new ColumnMappings(columnMappings)).destination(destination).assignmentStrategy(MultiStageQueryContext.getAssignmentStrategy(queryContext)).tuningConfig(new MSQTuningConfig(maxNumWorkers, maxRowsInMemory, rowsPerSegment, indexSpec)).build();
        MSQControllerTask controllerTask = new MSQControllerTask(taskId, querySpec, MSQTaskQueryMakerUtils.maskSensitiveJsonKeys(this.plannerContext.getSql()), this.plannerContext.queryContextMap(), sqlTypeNames, null);
        FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.runTask(taskId, (Object)controllerTask), (boolean)true);
        return QueryResponse.withEmptyContext((Sequence)Sequences.simple(Collections.singletonList(new Object[]{taskId})));
    }

    private static Map<String, ColumnType> buildAggregationIntermediateTypeMap(DruidQuery druidQuery) {
        Grouping grouping = druidQuery.getGrouping();
        if (grouping == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ColumnType> retVal = new HashMap<String, ColumnType>();
        for (AggregatorFactory aggregatorFactory : grouping.getAggregatorFactories()) {
            retVal.put(aggregatorFactory.getName(), aggregatorFactory.getIntermediateType());
        }
        return retVal;
    }
}

