/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle;

import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.java.util.common.StringUtils;

public class DurableStorageUtils {
    public static final String SUCCESS_MARKER_FILENAME = "__success";

    public static String getControllerDirectory(String controllerTaskId) {
        return StringUtils.format((String)"controller_%s", (Object[])new Object[]{IdUtils.validateId((String)"controller task ID", (String)controllerTaskId)});
    }

    public static String getSuccessFilePath(String controllerTaskId, int stageNumber, int workerNumber) {
        String folderName = DurableStorageUtils.getWorkerOutputFolderName(controllerTaskId, stageNumber, workerNumber);
        String fileName = StringUtils.format((String)"%s/%s", (Object[])new Object[]{folderName, SUCCESS_MARKER_FILENAME});
        return fileName;
    }

    public static String getWorkerOutputFolderName(String controllerTaskId, int stageNumber, int workerNumber) {
        return StringUtils.format((String)"%s/stage_%d/worker_%d", (Object[])new Object[]{DurableStorageUtils.getControllerDirectory(controllerTaskId), stageNumber, workerNumber});
    }

    public static String getTaskIdOutputsFolderName(String controllerTaskId, int stageNumber, int workerNumber, String taskId) {
        return StringUtils.format((String)"%s/taskId_%s", (Object[])new Object[]{DurableStorageUtils.getWorkerOutputFolderName(controllerTaskId, stageNumber, workerNumber), taskId});
    }

    public static String getPartitionOutputsFileNameForPartition(String controllerTaskId, int stageNumber, int workerNumber, String taskId, int partitionNumber) {
        return StringUtils.format((String)"%s/part_%d", (Object[])new Object[]{DurableStorageUtils.getTaskIdOutputsFolderName(controllerTaskId, stageNumber, workerNumber, taskId), partitionNumber});
    }
}

