/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameFileChannel;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.shuffle.DurableStorageUtils;
import org.apache.druid.storage.StorageConnector;

public class DurableStorageOutputChannelFactory
implements OutputChannelFactory {
    private static final Logger LOG = new Logger(DurableStorageOutputChannelFactory.class);
    private final String controllerTaskId;
    private final int workerNumber;
    private final int stageNumber;
    private final String taskId;
    private final int frameSize;
    private final StorageConnector storageConnector;

    public DurableStorageOutputChannelFactory(String controllerTaskId, int workerNumber, int stageNumber, String taskId, int frameSize, StorageConnector storageConnector) {
        this.controllerTaskId = (String)Preconditions.checkNotNull((Object)controllerTaskId, (Object)"controllerTaskId");
        this.workerNumber = workerNumber;
        this.stageNumber = stageNumber;
        this.taskId = taskId;
        this.frameSize = frameSize;
        this.storageConnector = (StorageConnector)Preconditions.checkNotNull((Object)storageConnector, (Object)"storageConnector");
    }

    public static DurableStorageOutputChannelFactory createStandardImplementation(String controllerTaskId, int workerNumber, int stageNumber, String taskId, int frameSize, StorageConnector storageConnector) {
        return new DurableStorageOutputChannelFactory(controllerTaskId, workerNumber, stageNumber, taskId, frameSize, storageConnector);
    }

    public OutputChannel openChannel(int partitionNumber) throws IOException {
        String fileName = DurableStorageUtils.getPartitionOutputsFileNameForPartition(this.controllerTaskId, this.stageNumber, this.workerNumber, this.taskId, partitionNumber);
        WritableFrameFileChannel writableChannel = new WritableFrameFileChannel(FrameFileWriter.open((WritableByteChannel)Channels.newChannel(this.storageConnector.write(fileName)), null));
        return OutputChannel.pair((WritableFrameChannel)writableChannel, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)this.frameSize), () -> ReadableNilFrameChannel.INSTANCE, (int)partitionNumber);
    }

    public OutputChannel openNilChannel(int partitionNumber) {
        String fileName = DurableStorageUtils.getPartitionOutputsFileNameForPartition(this.controllerTaskId, this.stageNumber, this.workerNumber, this.taskId, partitionNumber);
        try {
            FrameFileWriter.open((WritableByteChannel)Channels.newChannel(this.storageConnector.write(fileName)), null).close();
            return OutputChannel.nil((int)partitionNumber);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Unable to create empty remote output of stage [%d], partition [%d] for worker [%d]", new Object[]{this.stageNumber, partitionNumber, this.workerNumber});
        }
    }

    public void createSuccessFile(String taskId) throws IOException {
        String fileName = DurableStorageUtils.getSuccessFilePath(this.controllerTaskId, this.stageNumber, this.workerNumber);
        if (this.storageConnector.pathExists(fileName)) {
            LOG.warn("Path [%s] already exists. Won't attempt to rewrite on top of it.", new Object[]{fileName});
            return;
        }
        OutputStreamWriter os = new OutputStreamWriter(this.storageConnector.write(fileName), StandardCharsets.UTF_8);
        os.write(taskId);
        os.close();
    }
}

