/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableInputStreamFrameChannel;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.shuffle.DurableStorageUtils;
import org.apache.druid.storage.StorageConnector;

public class DurableStorageInputChannelFactory
implements InputChannelFactory {
    private static final Logger LOG = new Logger(DurableStorageInputChannelFactory.class);
    private final StorageConnector storageConnector;
    private final ExecutorService remoteInputStreamPool;
    private final String controllerTaskId;

    public DurableStorageInputChannelFactory(String controllerTaskId, StorageConnector storageConnector, ExecutorService remoteInputStreamPool) {
        this.controllerTaskId = (String)Preconditions.checkNotNull((Object)controllerTaskId, (Object)"controllerTaskId");
        this.storageConnector = (StorageConnector)Preconditions.checkNotNull((Object)storageConnector, (Object)"storageConnector");
        this.remoteInputStreamPool = (ExecutorService)Preconditions.checkNotNull((Object)remoteInputStreamPool, (Object)"remoteInputStreamPool");
    }

    public static DurableStorageInputChannelFactory createStandardImplementation(String controllerTaskId, StorageConnector storageConnector, Closer closer) {
        ExecutorService remoteInputStreamPool = Executors.newCachedThreadPool(Execs.makeThreadFactory((String)(controllerTaskId + "-remote-fetcher-%d")));
        closer.register(remoteInputStreamPool::shutdownNow);
        return new DurableStorageInputChannelFactory(controllerTaskId, storageConnector, remoteInputStreamPool);
    }

    @Override
    public ReadableFrameChannel openChannel(StageId stageId, int workerNumber, int partitionNumber) throws IOException {
        try {
            String remotePartitionPath = this.findSuccessfulPartitionOutput(this.controllerTaskId, workerNumber, stageId.getStageNumber(), partitionNumber);
            LOG.debug("Reading output of stage [%d], partition [%d] for worker [%d] from the file at path [%s]", new Object[]{stageId.getStageNumber(), partitionNumber, workerNumber, remotePartitionPath});
            RetryUtils.retry(() -> {
                if (!this.storageConnector.pathExists(remotePartitionPath)) {
                    throw new ISE("Could not find remote outputs of stage [%d] partition [%d] for worker [%d] at the path [%s]", new Object[]{stageId.getStageNumber(), partitionNumber, workerNumber, remotePartitionPath});
                }
                return Boolean.TRUE;
            }, throwable -> true, (int)10);
            InputStream inputStream = this.storageConnector.read(remotePartitionPath);
            return ReadableInputStreamFrameChannel.open((InputStream)inputStream, (String)remotePartitionPath, (ExecutorService)this.remoteInputStreamPool);
        }
        catch (Exception e) {
            throw new IOE((Throwable)e, "Encountered error while reading the output of stage [%d], partition [%d] for worker [%d]", new Object[]{stageId.getStageNumber(), partitionNumber, workerNumber});
        }
    }

    public String findSuccessfulPartitionOutput(String controllerTaskId, int workerNo, int stageNumber, int partitionNumber) throws IOException {
        String successfulTaskId;
        String successfulFilePath = DurableStorageUtils.getSuccessFilePath(controllerTaskId, stageNumber, workerNo);
        if (!this.storageConnector.pathExists(successfulFilePath)) {
            throw new ISE("No file present at the location [%s]. Unable to read the outputs of stage [%d], partition [%d] for the worker [%d]", new Object[]{successfulFilePath, stageNumber, partitionNumber, workerNo});
        }
        try (InputStream is = this.storageConnector.read(successfulFilePath);){
            successfulTaskId = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        if (successfulTaskId == null) {
            throw new ISE("Unable to read the task id from the file: [%s]", new Object[]{successfulFilePath});
        }
        LOG.debug("Reading output of stage [%d], partition [%d] from task id [%s]", new Object[]{stageNumber, partitionNumber, successfulTaskId});
        return DurableStorageUtils.getPartitionOutputsFileNameForPartition(controllerTaskId, stageNumber, workerNo, successfulTaskId, partitionNumber);
    }
}

