/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.rpc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.msq.rpc.CoordinatorServiceClient;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.timeline.DataSegment;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class CoordinatorServiceClientImpl
implements CoordinatorServiceClient {
    private final ServiceClient client;
    private final ObjectMapper jsonMapper;

    public CoordinatorServiceClientImpl(ServiceClient client, ObjectMapper jsonMapper) {
        this.client = (ServiceClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
    }

    @Override
    public ListenableFuture<DataSegment> fetchUsedSegment(String dataSource, String segmentId) {
        String path = StringUtils.format((String)"/druid/coordinator/v1/metadata/datasources/%s/segments/%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource), StringUtils.urlEncode((String)segmentId)});
        return FutureUtils.transform((ListenableFuture)this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, path), (HttpResponseHandler)new BytesFullResponseHandler()), holder -> this.deserialize((BytesFullResponseHolder)holder, (TypeReference)new TypeReference<DataSegment>(){}));
    }

    @Override
    public CoordinatorServiceClient withRetryPolicy(ServiceRetryPolicy retryPolicy) {
        return new CoordinatorServiceClientImpl(this.client.withRetryPolicy(retryPolicy), this.jsonMapper);
    }

    private <T> T deserialize(BytesFullResponseHolder bytesHolder, TypeReference<T> typeReference) {
        try {
            return (T)this.jsonMapper.readValue(bytesHolder.getContent(), typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

