/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.scan;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.kernel.MaxCountShuffleSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.QueryDefinitionBuilder;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.DataSourcePlan;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.msq.querykit.common.OffsetLimitFrameProcessorFactory;
import org.apache.druid.msq.querykit.scan.ScanQueryFrameProcessorFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class ScanQueryKit
implements QueryKit<ScanQuery> {
    private final ObjectMapper jsonMapper;

    public ScanQueryKit(ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public static RowSignature getAndValidateSignature(ScanQuery scanQuery, ObjectMapper jsonMapper) {
        RowSignature scanSignature;
        try {
            String s = scanQuery.context().getString("scanSignature");
            scanSignature = (RowSignature)jsonMapper.readValue(s, RowSignature.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        QueryKitUtils.verifyRowSignature(scanSignature);
        return scanSignature;
    }

    @Override
    public QueryDefinition makeQueryDefinition(String queryId, ScanQuery originalQuery, QueryKit<Query<?>> queryKit, ShuffleSpecFactory resultShuffleSpecFactory, int maxWorkerCount, int minStageNumber) {
        RowSignature signatureToUse;
        ShuffleSpec shuffleSpec;
        boolean hasLimitOrOffset;
        QueryDefinitionBuilder queryDefBuilder = QueryDefinition.builder().queryId(queryId);
        DataSourcePlan dataSourcePlan = DataSourcePlan.forDataSource(queryKit, queryId, originalQuery.getDataSource(), originalQuery.getQuerySegmentSpec(), originalQuery.getFilter(), maxWorkerCount, minStageNumber, false);
        dataSourcePlan.getSubQueryDefBuilder().ifPresent(queryDefBuilder::addAll);
        ScanQuery queryToRun = originalQuery.withDataSource(dataSourcePlan.getNewDataSource());
        int firstStageNumber = Math.max(minStageNumber, queryDefBuilder.getNextStageNumber());
        RowSignature scanSignature = ScanQueryKit.getAndValidateSignature(queryToRun, this.jsonMapper);
        boolean bl = hasLimitOrOffset = queryToRun.isLimited() || queryToRun.getScanRowsOffset() > 0L;
        if (queryToRun.getOrderBys().isEmpty() && hasLimitOrOffset) {
            shuffleSpec = new MaxCountShuffleSpec(ClusterBy.none(), 1, false);
            signatureToUse = scanSignature;
        } else {
            RowSignature.Builder signatureBuilder = RowSignature.builder().addAll(scanSignature);
            Granularity segmentGranularity = QueryKitUtils.getSegmentGranularityFromContext(this.jsonMapper, queryToRun.getContext());
            ArrayList<SortColumn> clusterByColumns = new ArrayList<SortColumn>();
            for (ScanQuery.OrderBy orderBy : queryToRun.getOrderBys()) {
                clusterByColumns.add(new SortColumn(orderBy.getColumnName(), orderBy.getOrder() == ScanQuery.Order.DESCENDING));
            }
            clusterByColumns.add(new SortColumn("__boost", false));
            signatureBuilder.add("__boost", ColumnType.LONG);
            ClusterBy clusterBy = QueryKitUtils.clusterByWithSegmentGranularity(new ClusterBy(clusterByColumns, 0), segmentGranularity);
            shuffleSpec = resultShuffleSpecFactory.build(clusterBy, false);
            signatureToUse = QueryKitUtils.sortableSignature(QueryKitUtils.signatureWithSegmentGranularity(signatureBuilder.build(), segmentGranularity), clusterBy.getColumns());
        }
        queryDefBuilder.add(StageDefinition.builder(Math.max(minStageNumber, queryDefBuilder.getNextStageNumber())).inputs(dataSourcePlan.getInputSpecs()).broadcastInputs(dataSourcePlan.getBroadcastInputs()).shuffleSpec(shuffleSpec).signature(signatureToUse).maxWorkerCount(dataSourcePlan.isSingleWorker() ? 1 : maxWorkerCount).processorFactory(new ScanQueryFrameProcessorFactory(queryToRun)));
        if (hasLimitOrOffset) {
            queryDefBuilder.add(StageDefinition.builder(firstStageNumber + 1).inputs(new StageInputSpec(firstStageNumber)).signature(signatureToUse).maxWorkerCount(1).shuffleSpec(new MaxCountShuffleSpec(ClusterBy.none(), 1, false)).processorFactory(new OffsetLimitFrameProcessorFactory(queryToRun.getScanRowsOffset(), queryToRun.isLimited() ? Long.valueOf(queryToRun.getScanRowsLimit()) : null)));
        }
        return queryDefBuilder.build();
    }
}

